/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.io;

import eu.clarin.weblicht.wlfxb.io.WLFormatException;
import eu.clarin.weblicht.wlfxb.io.XmlReaderWriter;
import eu.clarin.weblicht.wlfxb.md.xb.MetaData;
import eu.clarin.weblicht.wlfxb.tc.api.TextCorpus;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusStored;
import eu.clarin.weblicht.wlfxb.xb.WLData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;

public class WLDObjector {
    public static WLData read(InputStream inputStream) throws WLFormatException {
        WLData data = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WLData.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            data = (WLData)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return data;
    }

    public static WLData read(Reader reader) throws WLFormatException {
        WLData data = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WLData.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            data = (WLData)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new WLFormatException(e.getMessage(), e);
        }
        return data;
    }

    public static WLData read(File file) throws WLFormatException {
        WLData data = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            data = WLDObjector.read(fis);
        }
        catch (IOException e) {
            throw new WLFormatException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new WLFormatException(e);
                }
            }
        }
        return data;
    }

    public static void write(WLData wlData, OutputStream outputStream) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), outputStream, false);
    }

    public static void write(WLData wlData, File file) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), file, false);
    }

    public static void write(WLData wlData, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), outputStream, outputAsXmlFragment);
    }

    public static void write(WLData wlData, File file, boolean outputAsXmlFragment) throws WLFormatException {
        WLDObjector.write(wlData.getMetaData(), (TextCorpus)wlData.getTextCorpus(), file, outputAsXmlFragment);
    }

    public static void write(MetaData md, TextCorpus tc, File file, boolean outputAsXmlFragment) throws WLFormatException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            WLDObjector.write(md, tc, outputStream, outputAsXmlFragment);
        }
        catch (Exception e) {
            throw new WLFormatException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new WLFormatException(e);
                }
            }
        }
    }

    public static void write(MetaData md, TextCorpus tc, OutputStream outputStream, boolean outputAsXmlFragment) throws WLFormatException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        XMLOutputFactory xmlOututFactory = XMLOutputFactory.newInstance();
        XMLEventWriter xmlEventWriter = null;
        try {
            XMLEvent e;
            xmlEventWriter = new IndentingXMLEventWriter(xmlOututFactory.createXMLEventWriter(outputStream, "UTF-8"));
            if (!outputAsXmlFragment) {
                e = eventFactory.createStartDocument("UTF-8");
                xmlEventWriter.add(e);
                e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                xmlEventWriter.add(e);
                e = eventFactory.createProcessingInstruction("xml-model", "href=\"http://de.clarin.eu/images/weblicht-tutorials/resources/tcf-04/schemas/latest/d-spin_0_4.rnc\" type=\"application/relax-ng-compact-syntax\"");
                xmlEventWriter.add(e);
                e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
                xmlEventWriter.add(e);
            }
            Attribute versionAttr = eventFactory.createAttribute("version", "0.4");
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            attrs.add(versionAttr);
            Namespace ns = eventFactory.createNamespace("http://www.dspin.de/data");
            ArrayList<Namespace> nss = new ArrayList<Namespace>();
            nss.add(ns);
            e = eventFactory.createStartElement("", "http://www.dspin.de/data", "D-Spin", attrs.iterator(), nss.iterator());
            xmlEventWriter.add(e);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            JAXBContext mdContext = JAXBContext.newInstance((Class[])new Class[]{MetaData.class});
            Marshaller mdMarshaller = mdContext.createMarshaller();
            mdMarshaller.setProperty("jaxb.fragment", (Object)true);
            mdMarshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.clarin.eu/cmd/ http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1320657629623/xsd");
            mdMarshaller.marshal((Object)md, xmlEventWriter);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            JAXBContext tcContext = JAXBContext.newInstance((Class[])new Class[]{TextCorpusStored.class});
            Marshaller tcMarshaller = tcContext.createMarshaller();
            tcMarshaller.setProperty("jaxb.fragment", (Object)true);
            tcMarshaller.marshal((Object)tc, xmlEventWriter);
            e = eventFactory.createIgnorableSpace(XmlReaderWriter.NEW_LINE);
            xmlEventWriter.add(e);
            e = eventFactory.createEndElement("", "http://www.dspin.de/data", "D-Spin");
            xmlEventWriter.add(e);
            if (!outputAsXmlFragment) {
                e = eventFactory.createEndDocument();
                xmlEventWriter.add(e);
            }
        }
        catch (Exception ex) {
            throw new WLFormatException(ex.getMessage(), ex);
        }
        finally {
            if (xmlEventWriter != null) {
                try {
                    xmlEventWriter.flush();
                    xmlEventWriter.close();
                }
                catch (XMLStreamException ex2) {
                    throw new WLFormatException(ex2.getMessage(), ex2);
                }
            }
        }
    }
}

