/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.LexiconLayer;
import eu.clarin.weblicht.wlfxb.lx.xb.CooccurrencesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.EntriesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.FrequenciesLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.PosTagsLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SyllabificationsLayerStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SynonymsLayerStored;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum LexiconLayerTag {
    ENTRIES("entries", EntriesLayerStored.class),
    POSTAGS("POStags", PosTagsLayerStored.class),
    FREQUENCIES("frequencies", FrequenciesLayerStored.class),
    SYLLABIFICATIONS("syllabifications", SyllabificationsLayerStored.class),
    COOCCURRENCES("cooccurrences", CooccurrencesLayerStored.class),
    SYNONYMS("synonyms", SynonymsLayerStored.class);

    private static final Map<String, LexiconLayerTag> xmlNameToLayerTagMap;
    private static final Map<Class<? extends LexiconLayer>, LexiconLayerTag> classToLayerTagMap;
    private static final LexiconLayerTag[] layersOrder;
    private final String xmlName;
    private final Class<? extends LexiconLayer> layerClass;

    private LexiconLayerTag(String name, Class<? extends LexiconLayer> layerClass) {
        this.xmlName = name;
        this.layerClass = layerClass;
    }

    public final String getXmlName() {
        return this.xmlName;
    }

    public final Class<? extends LexiconLayer> getLayerClass() {
        return this.layerClass;
    }

    public static LexiconLayerTag getFromXmlName(String xmlName) {
        return xmlNameToLayerTagMap.get(xmlName);
    }

    public static List<LexiconLayerTag> orderedLayerTags() {
        return Arrays.asList(layersOrder);
    }

    public static LexiconLayerTag getFromClass(Class<? extends LexiconLayer> cl) {
        return classToLayerTagMap.get(cl);
    }

    static {
        xmlNameToLayerTagMap = new HashMap<String, LexiconLayerTag>(){
            {
                for (LexiconLayerTag layerTag : LexiconLayerTag.values()) {
                    this.put(layerTag.xmlName, layerTag);
                }
            }
        };
        classToLayerTagMap = new HashMap<Class<? extends LexiconLayer>, LexiconLayerTag>(){
            {
                for (LexiconLayerTag layerTag : LexiconLayerTag.values()) {
                    this.put(layerTag.getLayerClass(), layerTag);
                }
            }
        };
        layersOrder = new LexiconLayerTag[LexiconLayerTag.values().length];
        LexiconLayerTag[] arr$ = LexiconLayerTag.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LexiconLayerTag layerTag;
            LexiconLayerTag.layersOrder[layerTag.ordinal()] = layerTag = arr$[i$];
        }
    }
}

