/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.Sig;
import eu.clarin.weblicht.wlfxb.lx.api.Synonym;
import eu.clarin.weblicht.wlfxb.lx.api.SynonymsLayer;
import eu.clarin.weblicht.wlfxb.lx.api.Term;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.SigStored;
import eu.clarin.weblicht.wlfxb.lx.xb.SynonymStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermsContainerStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="synonyms")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SynonymsLayerStored
extends TermsContainerStored
implements SynonymsLayer {
    public static final String XML_NAME = "synonyms";
    @XmlElement(name="synonym")
    private List<SynonymStored> syns = new ArrayList<SynonymStored>();

    protected SynonymsLayerStored() {
    }

    protected SynonymsLayerStored(LexiconLayersConnector connector) {
        super(connector);
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        super.setLayersConnector(connector);
        for (SynonymStored syn : this.syns) {
            this.connect(syn);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.syns.isEmpty();
    }

    @Override
    public int size() {
        return this.syns.size();
    }

    @Override
    public Synonym getSynonym(int index) {
        return this.syns.get(index);
    }

    @Override
    public Synonym[] getSynonyms(Entry entry) {
        List<Synonym> list = this.connector.entry2ItsSyns.get(entry);
        if (list != null) {
            return list.toArray(new Synonym[list.size()]);
        }
        return new Synonym[0];
    }

    @Override
    public Entry[] getEntries(Synonym synonym) {
        if (synonym instanceof SynonymStored) {
            SynonymStored syn = (SynonymStored)synonym;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (TermStored t : syn.terms) {
                if (t.entryId == null) continue;
                entries.add(this.connector.entryId2ItsEntry.get(t.entryId));
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        return null;
    }

    @Override
    public String[] getTermsAsStrings(Synonym synonym, boolean includeAnnotatedTerm) {
        if (synonym instanceof SynonymStored) {
            SynonymStored syn = (SynonymStored)synonym;
            return super.getTermsAsStrings(syn.terms, includeAnnotatedTerm);
        }
        return null;
    }

    @Override
    public Synonym addSynonym(List<Term> terms) {
        SynonymStored syn = new SynonymStored();
        for (Term term : terms) {
            if (!(term instanceof TermStored)) continue;
            syn.terms.add((TermStored)term);
        }
        this.connect(syn);
        this.syns.add(syn);
        return syn;
    }

    private void connect(SynonymStored syn) {
        for (TermStored term : syn.terms) {
            if (term.entryId == null) continue;
            Entry entry = this.connector.entryId2ItsEntry.get(term.entryId);
            if (!this.connector.entry2ItsSyns.containsKey(entry)) {
                this.connector.entry2ItsSyns.put(entry, new ArrayList());
            }
            this.connector.entry2ItsSyns.get(entry).add(syn);
        }
    }

    @Override
    public Synonym addSynonym(Sig sig, List<Term> terms) {
        SynonymStored syn = (SynonymStored)this.addSynonym(terms);
        if (sig instanceof SigStored) {
            syn.sig = (SigStored)sig;
        }
        return syn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.syns.toString());
        return sb.toString();
    }
}

