/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.lx.xb;

import eu.clarin.weblicht.wlfxb.lx.api.Entry;
import eu.clarin.weblicht.wlfxb.lx.api.Sig;
import eu.clarin.weblicht.wlfxb.lx.api.Term;
import eu.clarin.weblicht.wlfxb.lx.api.TermsContainer;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.lx.xb.LexiconLayersConnector;
import eu.clarin.weblicht.wlfxb.lx.xb.SigStored;
import eu.clarin.weblicht.wlfxb.lx.xb.TermStored;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class TermsContainerStored
extends LexiconLayerStoredAbstract
implements TermsContainer {
    protected LexiconLayersConnector connector;

    protected TermsContainerStored() {
    }

    protected TermsContainerStored(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(LexiconLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public String[] getTermsAsStrings(List<? extends Term> terms, boolean includeAnnotatedTerm) {
        ArrayList<String> termsAsStrings = new ArrayList<String>();
        for (Term term : terms) {
            if (!(term instanceof TermStored)) continue;
            TermStored t = (TermStored)term;
            if (t.entryId != null) {
                if (!includeAnnotatedTerm) continue;
                termsAsStrings.add(this.connector.entryId2ItsEntry.get(t.entryId).getString());
                continue;
            }
            if (t.word == null) continue;
            termsAsStrings.add(t.word);
        }
        return termsAsStrings.toArray(new String[termsAsStrings.size()]);
    }

    @Override
    public Term createTerm(Entry entry) {
        TermStored term = new TermStored();
        term.entryId = entry.getID();
        return term;
    }

    @Override
    public Term createTerm(String word) {
        TermStored term = new TermStored();
        term.word = word;
        return term;
    }

    @Override
    public Sig createSig(String measure, float value) {
        SigStored sig = new SigStored(measure, value);
        return sig;
    }
}

