/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Constituent;
import eu.clarin.weblicht.wlfxb.tc.api.ConstituentParse;
import eu.clarin.weblicht.wlfxb.tc.api.ConstituentParsingLayer;
import eu.clarin.weblicht.wlfxb.tc.api.ConstituentReference;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.ConstituentParseStored;
import eu.clarin.weblicht.wlfxb.tc.xb.ConstituentReferenceStored;
import eu.clarin.weblicht.wlfxb.tc.xb.ConstituentStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="parsing")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ConstituentParsingLayerStored
extends TextCorpusLayerStoredAbstract
implements ConstituentParsingLayer {
    public static final String XML_NAME = "parsing";
    @XmlAttribute(name="tagset")
    private String tagset;
    @XmlElement(name="parse")
    private List<ConstituentParseStored> parses = new ArrayList<ConstituentParseStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (ConstituentParseStored parse : this.parses) {
            Constituent constituent = parse.getRoot();
            this.connect(constituent);
        }
    }

    private void connect(Constituent constituent) {
        if (constituent instanceof ConstituentStored) {
            ConstituentStored constitStored = (ConstituentStored)constituent;
            if (constitStored.constituentId == null) {
                constitStored.constituentId = "c_" + this.connector.constitId2ItsConstit.size();
            }
            this.connector.constitId2ItsConstit.put(constitStored.constituentId, constitStored);
        }
        if (!constituent.isTerminal()) {
            for (Constituent child : constituent.getChildren()) {
                this.connect(child);
            }
        }
    }

    protected ConstituentParsingLayerStored() {
    }

    protected ConstituentParsingLayerStored(String tagset) {
        this.tagset = tagset;
    }

    protected ConstituentParsingLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.parses.isEmpty();
    }

    @Override
    public int size() {
        return this.parses.size();
    }

    @Override
    public String getTagset() {
        return this.tagset;
    }

    @Override
    public ConstituentParse getParse(int index) {
        ConstituentParseStored parse = this.parses.get(index);
        return parse;
    }

    @Override
    public Constituent getParseRoot(int index) {
        ConstituentStored root = this.parses.get((int)index).constituentParseRoot;
        return root;
    }

    @Override
    public Token[] getTokens(ConstituentParse parse) {
        if (parse instanceof ConstituentParseStored) {
            ConstituentParseStored pStored = (ConstituentParseStored)parse;
            return this.getTokens(pStored.constituentParseRoot);
        }
        return null;
    }

    @Override
    public Token[] getTokens(Constituent constituent) {
        if (constituent instanceof ConstituentStored) {
            ConstituentStored cStored = (ConstituentStored)constituent;
            ArrayList<Token> terminalsTokens = new ArrayList<Token>();
            this.collectTerminalsTokens(terminalsTokens, cStored);
            Token[] tokens = new Token[terminalsTokens.size()];
            return terminalsTokens.toArray(tokens);
        }
        return null;
    }

    @Override
    public Constituent getConstituent(ConstituentReference cref) {
        if (cref instanceof ConstituentReferenceStored) {
            return this.connector.constitId2ItsConstit.get(((ConstituentReferenceStored)cref).constId);
        }
        return null;
    }

    private void collectTerminalsTokens(List<Token> terminalsTokens, ConstituentStored c) {
        block3: {
            block2: {
                if (!c.isTerminal()) break block2;
                if (c.isEmptyTerminal()) break block3;
                for (int i = 0; i < c.tokRefs.length; ++i) {
                    terminalsTokens.add(this.connector.tokenId2ItsToken.get(c.tokRefs[i]));
                }
                break block3;
            }
            for (ConstituentStored child : c.children) {
                this.collectTerminalsTokens(terminalsTokens, child);
            }
        }
    }

    @Override
    public Constituent createConstituent(String category, List<Constituent> children) {
        return this.createConstituent(category, null, children, null);
    }

    @Override
    public Constituent createConstituent(String category, String edge, List<Constituent> children) {
        return this.createConstituent(category, edge, children, null);
    }

    @Override
    public Constituent createConstituent(String category, List<Constituent> children, String id) {
        return this.createConstituent(category, null, children, id);
    }

    @Override
    public Constituent createConstituent(String category) {
        return this.createConstituent(category, null, new ArrayList<Constituent>(), null);
    }

    @Override
    public Constituent createConstituent(String category, String edge) {
        return this.createConstituent(category, edge, new ArrayList<Constituent>(), null);
    }

    @Override
    public Constituent createConstituent(String category, String edge, String id) {
        return this.createConstituent(category, edge, new ArrayList<Constituent>(), id);
    }

    @Override
    public Constituent createConstituent(String category, String edge, List<Constituent> children, String id) {
        ConstituentStored c = new ConstituentStored();
        c.category = category;
        c.edge = edge;
        if (id == null) {
            id = "c_" + this.connector.constitId2ItsConstit.size();
        }
        c.constituentId = id;
        this.connector.constitId2ItsConstit.put(id, c);
        for (Constituent child : children) {
            if (child instanceof ConstituentStored) {
                c.children.add((ConstituentStored)child);
                continue;
            }
            return null;
        }
        return c;
    }

    @Override
    public Constituent addChild(Constituent parent, Constituent child) {
        if (!(parent instanceof ConstituentStored) || !(child instanceof ConstituentStored)) {
            return null;
        }
        ((ConstituentStored)parent).children.add((ConstituentStored)child);
        return parent;
    }

    @Override
    public Constituent addSecondaryEdgeChild(Constituent parent, Constituent child, String edgeLabel) {
        if (!(parent instanceof ConstituentStored) || !(child instanceof ConstituentStored)) {
            return null;
        }
        ConstituentStored parentStored = (ConstituentStored)parent;
        ConstituentStored childStored = (ConstituentStored)child;
        ConstituentReferenceStored crefStored = new ConstituentReferenceStored(childStored, edgeLabel);
        parentStored.crefs.add(crefStored);
        return parent;
    }

    @Override
    public Constituent createTerminalConstituent(String category, List<Token> tokens) {
        return this.createTerminalConstituent(category, null, tokens, null);
    }

    @Override
    public Constituent createTerminalConstituent(String category, String edge, List<Token> tokens) {
        return this.createTerminalConstituent(category, edge, tokens, null);
    }

    @Override
    public Constituent createTerminalConstituent(String category, List<Token> tokens, String id) {
        return this.createTerminalConstituent(category, null, tokens, id);
    }

    @Override
    public Constituent createTerminalConstituent(String category, Token token) {
        return this.createTerminalConstituent(category, null, Arrays.asList(token), null);
    }

    @Override
    public Constituent createTerminalConstituent(String category, String edge, Token token) {
        return this.createTerminalConstituent(category, edge, Arrays.asList(token), null);
    }

    @Override
    public Constituent createTerminalConstituent(String category, String edge, Token token, String id) {
        return this.createTerminalConstituent(category, edge, Arrays.asList(token), id);
    }

    @Override
    public Constituent createTerminalConstituent(String category, String edge, List<Token> tokens, String id) {
        ConstituentStored c = new ConstituentStored();
        String[] tokRefs = WlfUtilities.tokens2TokenIds(tokens);
        c.category = category;
        c.edge = edge;
        c.tokRefs = tokRefs;
        if (id == null) {
            id = "c_" + this.connector.constitId2ItsConstit.size();
        }
        c.constituentId = id;
        this.connector.constitId2ItsConstit.put(id, c);
        return c;
    }

    @Override
    public ConstituentParse addParse(Constituent root) {
        ConstituentParseStored parse = new ConstituentParseStored();
        if (root instanceof ConstituentStored) {
            parse.constituentParseRoot = (ConstituentStored)root;
            this.parses.add(parse);
            return parse;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        sb.append("tagset").append(" ").append(this.getTagset());
        sb.append("}: ");
        sb.append(this.parses.toString());
        return sb.toString();
    }
}

