/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.MatchedItem;
import eu.clarin.weblicht.wlfxb.tc.xb.MatchedItemCategory;
import eu.clarin.weblicht.wlfxb.tc.xb.MatchedItemTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="item")
@XmlType(propOrder={"targets", "categories", "srcIds", "tokIds"})
public class MatchedItemStored
implements MatchedItem {
    public static final String XML_NAME = "item";
    public static final String XML_ATTRIBUTE_SOURCE_IDs = "srcIDs";
    public static final String XML_ELEMENT_TARGET = "target";
    public static final String XML_ELEMENT_CATEGORY = "category";
    @XmlAttribute(name="tokenIDs", required=true)
    protected String[] tokIds;
    @XmlAttribute(name="srcIDs")
    protected String[] srcIds;
    @XmlElement(name="target")
    protected List<MatchedItemTarget> targets = new ArrayList<MatchedItemTarget>();
    @XmlElement(name="category")
    protected List<MatchedItemCategory> categories = new ArrayList<MatchedItemCategory>();

    MatchedItemStored() {
    }

    MatchedItemStored(String[] tokIds, String[] srcIds, Map<String, String> targetsMap, Map<String, String> categoriesMap) {
        this.tokIds = tokIds;
        if (srcIds.length > 0) {
            this.srcIds = srcIds;
        }
        for (String name : targetsMap.keySet()) {
            this.targets.add(new MatchedItemTarget(name, targetsMap.get(name)));
        }
        for (String name : categoriesMap.keySet()) {
            this.categories.add(new MatchedItemCategory(name, categoriesMap.get(name)));
        }
    }

    @Override
    public String[] getOriginCorpusTokenIds() {
        return this.srcIds;
    }

    @Override
    public Set<String> getTargetNames() {
        HashSet<String> names = new HashSet<String>();
        for (MatchedItemTarget target : this.targets) {
            names.add(target.name);
        }
        return names;
    }

    @Override
    public String getTargetValue(String targetName) {
        for (MatchedItemTarget target : this.targets) {
            if (!targetName.equals(target.name)) continue;
            return target.value;
        }
        return null;
    }

    @Override
    public Set<String> getCategoriesNames() {
        HashSet<String> names = new HashSet<String>();
        for (MatchedItemCategory cat : this.categories) {
            names.add(cat.name);
        }
        return names;
    }

    @Override
    public String getCategoryValue(String categoryName) {
        for (MatchedItemCategory cat : this.categories) {
            if (!categoryName.equals(cat.name)) continue;
            return cat.value;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.toString(this.tokIds));
        if (this.srcIds != null) {
            sb.append(" ");
            sb.append(Arrays.toString(this.srcIds));
        }
        if (!this.targets.isEmpty()) {
            sb.append(" ");
            sb.append(this.targets);
        }
        if (!this.categories.isEmpty()) {
            sb.append(" ");
            sb.append(this.categories);
        }
        return sb.toString();
    }
}

