/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.MatchedCorpus;
import eu.clarin.weblicht.wlfxb.tc.api.MatchedItem;
import eu.clarin.weblicht.wlfxb.tc.api.MatchesLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.MatchedCorpusStored;
import eu.clarin.weblicht.wlfxb.tc.xb.MatchedItemStored;
import eu.clarin.weblicht.wlfxb.tc.xb.MatchesQuery;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="matches")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MatchesLayerStored
extends TextCorpusLayerStoredAbstract
implements MatchesLayer {
    public static final String XML_NAME = "matches";
    @XmlElement(name="query")
    private MatchesQuery query;
    @XmlElement(name="corpus")
    private List<MatchedCorpusStored> corpora = new ArrayList<MatchedCorpusStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (MatchedCorpusStored corpus : this.corpora) {
            for (MatchedItemStored item : corpus.matchedItems) {
                for (String tokRef : item.tokIds) {
                    connector.token2ItsMatchedItem.put(connector.tokenId2ItsToken.get(tokRef), item);
                }
            }
        }
    }

    protected MatchesLayerStored() {
    }

    protected MatchesLayerStored(String queryLanguage, String queryString) {
        this.query = new MatchesQuery(queryLanguage, queryString);
    }

    protected MatchesLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.corpora.isEmpty();
    }

    @Override
    public int size() {
        return this.corpora.size();
    }

    @Override
    public String getQueryType() {
        return this.query.type;
    }

    @Override
    public String getQueryString() {
        return this.query.value;
    }

    @Override
    public MatchedCorpus getCorpus(int index) {
        return this.corpora.get(index);
    }

    @Override
    public MatchedItem getMatchedItem(Token token) {
        MatchedItem item = this.connector.token2ItsMatchedItem.get(token);
        return item;
    }

    @Override
    public MatchedCorpus addCorpus(String corpusName, String corpusPID) {
        MatchedCorpusStored corpus = new MatchedCorpusStored(corpusName, corpusPID);
        this.corpora.add(corpus);
        return corpus;
    }

    @Override
    public MatchedItem addItem(MatchedCorpus corpusToAddItem, List<Token> itemTokens, List<String> itemOriginCorpusTokenIds) {
        return this.addItem(corpusToAddItem, itemTokens, itemOriginCorpusTokenIds, new HashMap<String, String>(0), new HashMap<String, String>(0));
    }

    @Override
    public MatchedItem addItem(MatchedCorpus corpusToAddItem, List<Token> itemTokens) {
        return this.addItem(corpusToAddItem, itemTokens, new ArrayList<String>(0), new HashMap<String, String>(0), new HashMap<String, String>(0));
    }

    @Override
    public MatchedItem addItem(MatchedCorpus corpusToAddItem, List<Token> itemTokens, Map<String, String> itemTargets, Map<String, String> itemCategories) {
        return this.addItem(corpusToAddItem, itemTokens, new ArrayList<String>(0), itemTargets, itemCategories);
    }

    @Override
    public MatchedItem addItem(MatchedCorpus corpusToAddItem, List<Token> itemTokens, List<String> itemOriginCorpusTokenIds, Map<String, String> itemTargets, Map<String, String> itemCategories) {
        if (!(corpusToAddItem instanceof MatchedCorpusStored)) {
            return null;
        }
        String[] srcIds = new String[itemOriginCorpusTokenIds.size()];
        String[] tokIds = WlfUtilities.tokens2TokenIds(itemTokens);
        srcIds = itemOriginCorpusTokenIds.toArray(srcIds);
        MatchedItemStored item = new MatchedItemStored(tokIds, srcIds, itemTargets, itemCategories);
        ((MatchedCorpusStored)corpusToAddItem).matchedItems.add(item);
        for (int i = 0; i < itemTokens.size(); ++i) {
            Token token = itemTokens.get(i);
            this.connector.token2ItsMatchedItem.put(token, item);
        }
        return item;
    }

    @Override
    public Token[] getTokens(MatchedItem item) {
        if (item instanceof MatchedItemStored) {
            MatchedItemStored iStored = (MatchedItemStored)item;
            Token[] tokens = new Token[iStored.tokIds.length];
            for (int i = 0; i < iStored.tokIds.length; ++i) {
                tokens[i] = this.connector.tokenId2ItsToken.get(iStored.tokIds[i]);
            }
            return tokens;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        sb.append(this.query.type).append(" ").append(this.query.value);
        sb.append("}: ");
        sb.append(this.corpora.toString());
        return sb.toString();
    }
}

