/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Feature;
import eu.clarin.weblicht.wlfxb.tc.api.MorphologyAnalysis;
import eu.clarin.weblicht.wlfxb.tc.api.MorphologyLayer;
import eu.clarin.weblicht.wlfxb.tc.api.MorphologySegment;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.FeatureStored;
import eu.clarin.weblicht.wlfxb.tc.xb.FeatureStructureStored;
import eu.clarin.weblicht.wlfxb.tc.xb.MorphologyAnalysisStored;
import eu.clarin.weblicht.wlfxb.tc.xb.MorphologySegmentStored;
import eu.clarin.weblicht.wlfxb.tc.xb.MorphologyTagStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="morphology")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MorphologyLayerStored
extends TextCorpusLayerStoredAbstract
implements MorphologyLayer {
    public static final String XML_NAME = "morphology";
    @XmlAttribute(name="charOffsets")
    private Boolean hasCharoffsets;
    @XmlAttribute(name="segmentation")
    private Boolean hasSegmentation;
    @XmlElement(name="analysis")
    private List<MorphologyAnalysisStored> moans = new ArrayList<MorphologyAnalysisStored>();
    private TextCorpusLayersConnector connector;

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (MorphologyAnalysisStored a : this.moans) {
            for (String tokRef : a.tokRefs) {
                connector.token2ItsAnalysis.put(connector.tokenId2ItsToken.get(tokRef), a);
            }
        }
    }

    protected MorphologyLayerStored() {
    }

    protected MorphologyLayerStored(Boolean hasSegmentation) {
        this.hasSegmentation = hasSegmentation;
    }

    protected MorphologyLayerStored(Boolean hasSegmentation, Boolean hasCharOffsets) {
        this(hasSegmentation);
        this.hasCharoffsets = hasCharOffsets;
    }

    protected MorphologyLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isEmpty() {
        return this.moans.isEmpty();
    }

    @Override
    public int size() {
        return this.moans.size();
    }

    @Override
    public boolean hasSegmentation() {
        return this.hasSegmentation == Boolean.TRUE;
    }

    @Override
    public boolean hasCharoffsets() {
        return this.hasCharoffsets == Boolean.TRUE;
    }

    @Override
    public MorphologyAnalysis getAnalysis(int index) {
        return this.moans.get(index);
    }

    @Override
    public MorphologyAnalysis getAnalysis(Token token) {
        MorphologyAnalysis a = this.connector.token2ItsAnalysis.get(token);
        return a;
    }

    @Override
    public Token[] getTokens(MorphologyAnalysis analysis) {
        if (analysis instanceof MorphologyAnalysisStored) {
            MorphologyAnalysisStored a = (MorphologyAnalysisStored)analysis;
            return WlfUtilities.tokenIdsToTokens(a.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public MorphologyAnalysis addAnalysis(Token analysedToken, List<Feature> morphologyFeatures) {
        ArrayList<Token> toks = new ArrayList<Token>();
        toks.add(analysedToken);
        return this.addAnalysis(toks, morphologyFeatures);
    }

    @Override
    public MorphologyAnalysis addAnalysis(Token analysedToken, List<Feature> morphologyFeatures, List<MorphologySegment> segments) {
        ArrayList<Token> toks = new ArrayList<Token>();
        toks.add(analysedToken);
        return this.addAnalysis(toks, morphologyFeatures, segments);
    }

    @Override
    public MorphologyAnalysis addAnalysis(List<Token> analysedTokens, List<Feature> morphologyFeatures) {
        MorphologyAnalysisStored a = new MorphologyAnalysisStored();
        FeatureStructureStored fs = new FeatureStructureStored();
        for (Feature f : morphologyFeatures) {
            if (!(f instanceof FeatureStored)) continue;
            fs.features.add((FeatureStored)f);
        }
        if (!fs.features.isEmpty()) {
            a.tag = new MorphologyTagStored();
            a.tag.fs = fs;
        }
        a.tokRefs = new String[analysedTokens.size()];
        for (int i = 0; i < analysedTokens.size(); ++i) {
            Token token = analysedTokens.get(i);
            a.tokRefs[i] = token.getID();
            this.connector.token2ItsAnalysis.put(token, a);
        }
        this.moans.add(a);
        return a;
    }

    @Override
    public MorphologyAnalysis addAnalysis(List<Token> analysedTokens, List<Feature> morphologyFeatures, List<MorphologySegment> segments) {
        MorphologyAnalysisStored a = (MorphologyAnalysisStored)this.addAnalysis(analysedTokens, morphologyFeatures);
        for (MorphologySegment segment : segments) {
            if (!(segment instanceof MorphologySegmentStored)) continue;
            MorphologySegmentStored s = (MorphologySegmentStored)segment;
            this.hasSegmentation = true;
            if (s.hasCharoffsets()) {
                this.hasCharoffsets = true;
            }
            if (a.segments == null) {
                a.segments = new ArrayList<MorphologySegmentStored>();
            }
            a.segments.add(s);
        }
        return a;
    }

    @Override
    public Feature createFeature(String name, String value) {
        FeatureStored f = new FeatureStored();
        f.name = name;
        f.value = value;
        return f;
    }

    @Override
    public Feature createFeature(String name, List<Feature> subfeatures) {
        FeatureStored f = new FeatureStored();
        f.name = name;
        f.fs = new FeatureStructureStored();
        for (Feature sf : subfeatures) {
            if (!(sf instanceof FeatureStored)) continue;
            f.fs.features.add((FeatureStored)sf);
        }
        return f;
    }

    @Override
    public MorphologySegment createSegment(String type, String category, String function, Integer start, Integer end, String value) {
        MorphologySegmentStored ms = new MorphologySegmentStored();
        ms.type = type;
        ms.function = function;
        ms.category = category;
        ms.start = start;
        ms.end = end;
        ms.value = value;
        return ms;
    }

    @Override
    public MorphologySegment createSegment(String type, String category, String function, Integer start, Integer end, List<MorphologySegment> subsegments) {
        MorphologySegmentStored ms = new MorphologySegmentStored();
        ms.type = type;
        ms.function = function;
        ms.category = category;
        ms.start = start;
        ms.end = end;
        ms.subsegments = new ArrayList<MorphologySegmentStored>();
        for (MorphologySegment s : subsegments) {
            if (!(s instanceof MorphologySegmentStored)) continue;
            ms.subsegments.add((MorphologySegmentStored)s);
        }
        return ms;
    }

    protected void beforeMarshal(Marshaller m) {
        this.setFalseAttrToNull();
    }

    private void setFalseAttrToNull() {
        if (this.hasSegmentation == Boolean.FALSE) {
            this.hasSegmentation = null;
        }
        if (this.hasCharoffsets == Boolean.FALSE) {
            this.hasCharoffsets = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" {");
        if (this.hasCharoffsets != null) {
            sb.append("charOffsets").append(" ").append(this.hasCharoffsets);
        }
        if (this.hasSegmentation != null) {
            sb.append(" segmentation ").append(this.hasSegmentation);
        }
        sb.append("}: ");
        sb.append(this.moans.toString());
        return sb.toString();
    }
}

