/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.NamedEntitiesLayer;
import eu.clarin.weblicht.wlfxb.tc.api.NamedEntity;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.NamedEntityStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="namedEntities")
@XmlAccessorType(value=XmlAccessType.NONE)
public class NamedEntitiesLayerStored
extends TextCorpusLayerStoredAbstract
implements NamedEntitiesLayer {
    public static final String XML_NAME = "namedEntities";
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlElement(name="entity")
    private List<NamedEntityStored> entities = new ArrayList<NamedEntityStored>();
    private Set<String> foundTypes = new HashSet<String>();
    private TextCorpusLayersConnector connector;

    protected NamedEntitiesLayerStored() {
    }

    protected NamedEntitiesLayerStored(String type) {
        this.type = type;
    }

    protected NamedEntitiesLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (NamedEntityStored ne : this.entities) {
            for (String tokRef : ne.tokRefs) {
                Token tok = connector.tokenId2ItsToken.get(tokRef);
                if (!connector.token2ItsNE.containsKey(tok)) {
                    connector.token2ItsNE.put(tok, new ArrayList());
                }
                connector.token2ItsNE.get(tok).add(ne);
            }
            this.foundTypes.add(ne.getType());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> getFoundTypes() {
        return this.foundTypes;
    }

    @Override
    public NamedEntity getEntity(int index) {
        return this.entities.get(index);
    }

    @Override
    public NamedEntity getEntity(Token token) {
        List<NamedEntity> nes = this.connector.token2ItsNE.get(token);
        if (nes != null && !nes.isEmpty()) {
            return nes.get(0);
        }
        return null;
    }

    @Override
    public List<NamedEntity> getEntities(Token token) {
        List<NamedEntity> nes = this.connector.token2ItsNE.get(token);
        return nes;
    }

    @Override
    public Token[] getTokens(NamedEntity entity) {
        if (entity instanceof NamedEntityStored) {
            NamedEntityStored ne = (NamedEntityStored)entity;
            return WlfUtilities.tokenIdsToTokens(ne.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public NamedEntity addEntity(String entityType, Token tagToken) {
        List<Token> tagTokens = Arrays.asList(tagToken);
        return this.addEntity(entityType, tagTokens);
    }

    @Override
    public NamedEntity addEntity(String entityType, List<Token> entityTokens) {
        NamedEntityStored ne = new NamedEntityStored();
        ne.type = entityType;
        ne.tokRefs = new String[entityTokens.size()];
        for (int i = 0; i < entityTokens.size(); ++i) {
            Token token = entityTokens.get(i);
            ne.tokRefs[i] = token.getID();
            Token tok = this.connector.tokenId2ItsToken.get(token.getID());
            if (!this.connector.token2ItsNE.containsKey(tok)) {
                this.connector.token2ItsNE.put(tok, new ArrayList());
            }
            this.connector.token2ItsNE.get(tok).add(ne);
        }
        this.entities.add(ne);
        this.foundTypes.add(ne.getType());
        return ne;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.type);
        sb.append("} :");
        sb.append(this.entities.toString());
        return sb.toString();
    }
}

