/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.CorrectionOperation;
import eu.clarin.weblicht.wlfxb.tc.api.OrthCorrection;
import eu.clarin.weblicht.wlfxb.tc.api.OrthographyLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.OrthCorrectionStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="orthography")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OrthographyLayerStored
extends TextCorpusLayerStoredAbstract
implements OrthographyLayer {
    public static final String XML_NAME = "orthography";
    @XmlElement(name="correction")
    private List<OrthCorrectionStored> corrections = new ArrayList<OrthCorrectionStored>();
    private TextCorpusLayersConnector connector;

    protected OrthographyLayerStored() {
    }

    protected OrthographyLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (int i = 0; i < this.corrections.size(); ++i) {
            OrthCorrectionStored corr = this.corrections.get(i);
            for (String tokRef : corr.tokRefs) {
                connector.token2ItsCorrection.put(connector.tokenId2ItsToken.get(tokRef), corr);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.corrections.isEmpty();
    }

    @Override
    public int size() {
        return this.corrections.size();
    }

    @Override
    public OrthCorrection getCorrection(int index) {
        OrthCorrection corr = this.corrections.get(index);
        return corr;
    }

    @Override
    public OrthCorrection getCorrection(Token token) {
        OrthCorrection corr = this.connector.token2ItsCorrection.get(token);
        return corr;
    }

    @Override
    public Token[] getTokens(OrthCorrection correction) {
        if (correction instanceof OrthCorrectionStored) {
            OrthCorrectionStored corrStored = (OrthCorrectionStored)correction;
            return WlfUtilities.tokenIdsToTokens(corrStored.tokRefs, this.connector.tokenId2ItsToken);
        }
        return null;
    }

    @Override
    public OrthCorrection addCorrection(String correctionString, Token correctedToken, CorrectionOperation operation) {
        List<Token> corrTokens = Arrays.asList(correctedToken);
        return this.addCorrection(correctionString, corrTokens, operation);
    }

    @Override
    public OrthCorrection addCorrection(String correctionString, List<Token> correctedTokens, CorrectionOperation operation) {
        OrthCorrectionStored corr = new OrthCorrectionStored();
        corr.corrString = correctionString;
        corr.tokRefs = new String[correctedTokens.size()];
        corr.operation = operation;
        for (int i = 0; i < correctedTokens.size(); ++i) {
            Token corrToken = correctedTokens.get(i);
            corr.tokRefs[i] = corrToken.getID();
            this.connector.token2ItsCorrection.put(corrToken, corr);
        }
        this.corrections.add(corr);
        return corr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" : ");
        sb.append(this.corrections.toString());
        return sb.toString();
    }
}

