/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.wlfxb.tc.xb;

import eu.clarin.weblicht.wlfxb.tc.api.Relation;
import eu.clarin.weblicht.wlfxb.tc.api.RelationsLayer;
import eu.clarin.weblicht.wlfxb.tc.api.Token;
import eu.clarin.weblicht.wlfxb.tc.xb.RelationStored;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayerStoredAbstract;
import eu.clarin.weblicht.wlfxb.tc.xb.TextCorpusLayersConnector;
import eu.clarin.weblicht.wlfxb.utils.WlfUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="relations")
@XmlAccessorType(value=XmlAccessType.NONE)
@Deprecated
public class RelationsLayerStored
extends TextCorpusLayerStoredAbstract
implements RelationsLayer {
    public static final String XML_NAME = "relations";
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlElement(name="relation")
    private List<RelationStored> relations = new ArrayList<RelationStored>();
    private TextCorpusLayersConnector connector;

    protected RelationsLayerStored() {
    }

    protected RelationsLayerStored(String type) {
        this.type = type;
    }

    protected RelationsLayerStored(TextCorpusLayersConnector connector) {
        this.connector = connector;
    }

    @Override
    protected void setLayersConnector(TextCorpusLayersConnector connector) {
        this.connector = connector;
        for (RelationStored rel : this.relations) {
            for (String tokRef : rel.tokRefs) {
                connector.token2ItsRelation.put(connector.tokenId2ItsToken.get(tokRef), rel);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.relations.isEmpty();
    }

    @Override
    public int size() {
        return this.relations.size();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Relation getRelation(int index) {
        return this.relations.get(index);
    }

    @Override
    public Relation getRelation(Token token) {
        return this.connector.token2ItsRelation.get(token);
    }

    @Override
    public Token[] getTokens(Relation relation) {
        if (relation instanceof RelationStored) {
            RelationStored r = (RelationStored)relation;
            return WlfUtilities.tokenIdsToTokens(r.tokRefs, this.connector.tokenId2ItsToken);
        }
        throw new UnsupportedOperationException(WlfUtilities.layersErrorMessage(Relation.class, RelationsLayer.class));
    }

    @Override
    public Relation addRelation(String function, Token relationToken) {
        List<Token> relTokens = Arrays.asList(relationToken);
        return this.addRelation(function, relTokens);
    }

    @Override
    public Relation addRelation(Token relationToken) {
        return this.addRelation(null, relationToken);
    }

    @Override
    public Relation addRelation(String function, List<Token> relationTokens) {
        RelationStored rel = new RelationStored();
        rel.function = function;
        rel.tokRefs = new String[relationTokens.size()];
        for (int i = 0; i < relationTokens.size(); ++i) {
            Token token = relationTokens.get(i);
            rel.tokRefs[i] = token.getID();
            this.connector.token2ItsRelation.put(token, rel);
        }
        this.relations.add(rel);
        return rel;
    }

    @Override
    public Relation addRelation(List<Token> relationTokens) {
        return this.addRelation(null, relationTokens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(XML_NAME);
        sb.append(" ");
        sb.append("{");
        sb.append(this.type);
        sb.append("} :");
        sb.append(this.relations.toString());
        return sb.toString();
    }
}

