/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.concurrent;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
public final class TaskUtil {
    private static final ExecutorService VIRTUAL_THREAD_EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();

    private TaskUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static CompletableFuture<Void> runAsync(@NonNull CheckedRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> {
            runnable.run();
            return null;
        });
    }

    @NonNull
    public static CompletableFuture<Void> runVirtualAsync(@NonNull CheckedRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return TaskUtil.supplyVirtualAsync((CheckedFunction0 & Serializable)() -> {
            runnable.run();
            return null;
        });
    }

    @NonNull
    public static <V> CompletableFuture<V> supplyAsync(@NonNull CheckedFunction0<V> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.apply();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    @NonNull
    public static <V> CompletableFuture<V> supplyVirtualAsync(@NonNull CheckedFunction0<V> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.apply();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        }, VIRTUAL_THREAD_EXECUTOR);
    }

    @NonNull
    public static <V> CompletableFuture<V> finishedFuture(@Nullable Object result) {
        if (result instanceof Throwable) {
            Throwable throwable = (Throwable)result;
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.completedFuture(result);
    }

    public static <V> @UnknownNullability V getOrDefault(@NonNull Future<V> future, @Nullable V defaultValue) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        return TaskUtil.getOrDefault(future, Duration.ZERO, defaultValue);
    }

    public static <V> @UnknownNullability V getOrDefault(@NonNull Future<V> future, @NonNull Duration timeout, @Nullable V defaultValue) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            boolean useInfiniteTimeout = timeout.isZero() || timeout.isNegative();
            return useInfiniteTimeout ? future.get() : future.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            return defaultValue;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return defaultValue;
        }
    }
}

