/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.common.jvm;

import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public enum JavaVersion {
    JAVA_UNSUPPORTED(-1, -1.0, "Unsupported Java"),
    JAVA_NEXT(Integer.MAX_VALUE, Double.MAX_VALUE, "Next Java"),
    JAVA_8(8, 52.0, "Java 8"),
    JAVA_9(9, 53.0, "Java 9"),
    JAVA_10(10, 54.0, "Java 10"),
    JAVA_11(11, 55.0, "Java 11"),
    JAVA_12(12, 56.0, "Java 12"),
    JAVA_13(13, 57.0, "Java 13"),
    JAVA_14(14, 58.0, "Java 14"),
    JAVA_15(15, 59.0, "Java 15"),
    JAVA_16(16, 60.0, "Java 16"),
    JAVA_17(17, 61.0, "Java 17"),
    JAVA_18(18, 62.0, "Java 18"),
    JAVA_19(19, 63.0, "Java 19"),
    JAVA_20(20, 64.0, "Java 20"),
    JAVA_21(21, 65.0, "Java 21"),
    JAVA_22(22, 66.0, "Java 22"),
    JAVA_23(23, 67.0, "Java 23"),
    JAVA_24(24, 68.0, "Java 24");

    private static final JavaVersion[] JAVA_VERSIONS;
    private static final JavaVersion LATEST_VERSION;
    private static final JavaVersion RUNTIME_VERSION;
    private final int majorVersion;
    private final double classFileVersion;
    private final String displayName;

    private JavaVersion(@NonNull int majorVersion, double classFileVersion, String displayName) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        this.majorVersion = majorVersion;
        this.classFileVersion = classFileVersion;
        this.displayName = displayName;
    }

    @NonNull
    private static JavaVersion[] resolveActualJavaVersions() {
        JavaVersion[] values = JavaVersion.values();
        return Arrays.copyOfRange(values, JAVA_8.ordinal(), values.length);
    }

    @NonNull
    private static JavaVersion resolveRuntimeVersion() {
        double jcv = Double.parseDouble(System.getProperty("java.class.version"));
        return JavaVersion.fromClassFileVersion(jcv).orElse(jcv > LATEST_VERSION.classFileVersion() ? JAVA_NEXT : JAVA_UNSUPPORTED);
    }

    @NonNull
    public static JavaVersion runtimeVersion() {
        return RUNTIME_VERSION;
    }

    @NonNull
    public static Optional<JavaVersion> fromClassFileVersion(double classFileVersion) {
        for (JavaVersion javaVersion : JAVA_VERSIONS) {
            if (javaVersion.classFileVersion() != classFileVersion) continue;
            return Optional.of(javaVersion);
        }
        return Optional.empty();
    }

    @NonNull
    public static JavaVersion guessFromMajor(int major) {
        return JavaVersion.fromMajor(major).orElse(major > LATEST_VERSION.majorVersion() ? JAVA_NEXT : JAVA_UNSUPPORTED);
    }

    @NonNull
    public static Optional<JavaVersion> fromMajor(int version) {
        for (JavaVersion javaVersion : JAVA_VERSIONS) {
            if (javaVersion.majorVersion() != version) continue;
            return Optional.of(javaVersion);
        }
        return Optional.empty();
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public double classFileVersion() {
        return this.classFileVersion;
    }

    @NonNull
    public String displayName() {
        return this.displayName;
    }

    public boolean supported() {
        return this != JAVA_UNSUPPORTED;
    }

    public boolean atOrAbove() {
        return RUNTIME_VERSION.isNewerOrAt(this);
    }

    public boolean isInRange(@NonNull JavaVersion lowerBound, @NonNull JavaVersion upperBound) {
        if (lowerBound == null) {
            throw new NullPointerException("lowerBound is marked non-null but is null");
        }
        if (upperBound == null) {
            throw new NullPointerException("upperBound is marked non-null but is null");
        }
        return this.isNewerOrAt(lowerBound) && this.isOlderOrAt(upperBound);
    }

    public boolean isNewerOrAt(@NonNull JavaVersion version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return version.supported() && this.classFileVersion >= version.classFileVersion;
    }

    public boolean isOlderOrAt(@NonNull JavaVersion version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.supported() && this.classFileVersion <= version.classFileVersion;
    }

    static {
        JAVA_VERSIONS = JavaVersion.resolveActualJavaVersions();
        LATEST_VERSION = JAVA_VERSIONS[JAVA_VERSIONS.length - 1];
        RUNTIME_VERSION = JavaVersion.resolveRuntimeVersion();
    }
}

