/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.registry;

import eu.cloudnetservice.ext.platforminject.api.spi.PlatformPluginManagerRegistry;
import java.util.Objects;
import java.util.ServiceLoader;
import lombok.NonNull;

public final class PlatformManagerRegistryHolder {
    private static PlatformPluginManagerRegistry registry;

    public PlatformManagerRegistryHolder() {
        throw new UnsupportedOperationException();
    }

    public static void init(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        if (registry == null) {
            ServiceLoader<PlatformPluginManagerRegistry> serviceLoader = ServiceLoader.load(PlatformPluginManagerRegistry.class, classLoader);
            registry = serviceLoader.findFirst().orElseThrow();
        }
    }

    @NonNull
    public static PlatformPluginManagerRegistry registry() {
        return Objects.requireNonNull(registry, "registry not yet initialized");
    }
}

