/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.util;

import lombok.NonNull;

public final class PluginUtil {
    private PluginUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static String buildClassName(@NonNull String pluginName, @NonNull String platformName, @NonNull String suffix) {
        char firstChar;
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (platformName == null) {
            throw new NullPointerException("platformName is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (((String)platformName).length() > 1 && Character.isLowerCase(firstChar = ((String)platformName).charAt(0))) {
            platformName = Character.toUpperCase(firstChar) + ((String)platformName).substring(1);
        }
        String fullName = (String)platformName + pluginName;
        StringBuilder builder = new StringBuilder();
        for (char c : fullName.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$' || c == '_') {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        return String.format("Generated%s%s", builder, suffix);
    }
}

