/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.catchexception.throwable;

import com.googlecode.catchexception.throwable.ThrowableCaptor;
import com.googlecode.catchexception.throwable.ThrowableNotThrownAssertionError;
import com.googlecode.catchexception.throwable.ThrowingCallable;
import com.googlecode.catchexception.throwable.internal.ThrowableHolder;

public class CatchThrowable {
    public static Throwable caughtThrowable() {
        return ThrowableHolder.get();
    }

    public static void verifyThrowable(ThrowingCallable actor) {
        CatchThrowable.verifyThrowable(actor, Throwable.class);
    }

    public static void verifyThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz) {
        CatchThrowable.validateArguments(actor, clazz);
        try {
            CatchThrowable.catchThrowable(actor, clazz, true);
        }
        catch (ThrowableNotThrownAssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void catchThrowable(ThrowingCallable actor) {
        CatchThrowable.validateArguments(actor, Throwable.class);
        try {
            CatchThrowable.catchThrowable(actor, Throwable.class, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void catchThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz) throws Throwable {
        CatchThrowable.validateArguments(actor, clazz);
        CatchThrowable.catchThrowable(actor, clazz, false);
    }

    private static void catchThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz, boolean assertException) throws Throwable {
        CatchThrowable.resetCaughtThrowable();
        Throwable e = ThrowableCaptor.captureThrowable(actor);
        if (e == null) {
            if (!assertException) {
                return;
            }
            throw new ThrowableNotThrownAssertionError(clazz);
        }
        if (!clazz.isAssignableFrom(e.getClass())) {
            if (assertException) {
                throw new ThrowableNotThrownAssertionError(clazz, e);
            }
            throw e;
        }
        ThrowableHolder.set(e);
    }

    private static void validateArguments(ThrowingCallable actor, Class<? extends Throwable> clazz) {
        if (actor == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("throwableClazz must not be null");
        }
    }

    public static void resetCaughtThrowable() {
        ThrowableHolder.set(null);
    }
}

