/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.catchexception.throwable;

import com.googlecode.catchexception.throwable.ExceptionUtil;
import com.googlecode.catchexception.throwable.ThrowableCaptor;
import com.googlecode.catchexception.throwable.ThrowableHolder;
import com.googlecode.catchexception.throwable.ThrowableNotThrownAssertionError;
import com.googlecode.catchexception.throwable.ThrowingCallable;

public class CatchThrowable {
    public static <T extends Throwable> T caughtThrowable() {
        return (T)ThrowableHolder.get();
    }

    public static <T extends Throwable> T caughtThrowable(Class<T> caughtThrowableType) {
        return (T)ThrowableHolder.get();
    }

    public static void verifyThrowable(ThrowingCallable actor) {
        CatchThrowable.verifyThrowable(actor, Throwable.class);
    }

    public static void verifyThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz) {
        CatchThrowable.validateArguments(actor, clazz);
        CatchThrowable.catchThrowable(actor, clazz, true);
    }

    public static void catchThrowable(ThrowingCallable actor) {
        CatchThrowable.validateArguments(actor, Throwable.class);
        CatchThrowable.catchThrowable(actor, Throwable.class, false);
    }

    public static void catchThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz) {
        CatchThrowable.validateArguments(actor, clazz);
        CatchThrowable.catchThrowable(actor, clazz, false);
    }

    private static void catchThrowable(ThrowingCallable actor, Class<? extends Throwable> clazz, boolean assertException) {
        CatchThrowable.resetCaughtThrowable();
        Throwable throwable = ThrowableCaptor.captureThrowable(actor);
        if (throwable == null) {
            if (!assertException) {
                return;
            }
            throw new ThrowableNotThrownAssertionError(clazz);
        }
        if (clazz.isAssignableFrom(throwable.getClass())) {
            ThrowableHolder.set(throwable);
        } else {
            if (assertException) {
                throw new ThrowableNotThrownAssertionError(clazz, throwable);
            }
            ExceptionUtil.sneakyThrow(throwable);
        }
    }

    private static void validateArguments(ThrowingCallable actor, Class<? extends Throwable> clazz) {
        if (actor == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("throwableClazz must not be null");
        }
    }

    public static void resetCaughtThrowable() {
        ThrowableHolder.set(null);
    }
}

