package org.andengine.opengl.vbo;

import android.opengl.GLES20;

/**
 * (c) Zynga 2012
 *
 * @author Nicolas Gramlich <ngramlich@zynga.com>
 * @since 15:41:14 - 27.03.2012
 */
public enum DrawType {
	// ===========================================================
	// Elements
	// ===========================================================

	STATIC(GLES20.GL_STATIC_DRAW),
	DYNAMIC(GLES20.GL_DYNAMIC_DRAW),
	STREAM(GLES20.GL_STREAM_DRAW);

	// ===========================================================
	// Constants
	// ===========================================================

	private final int mUsage;

	// ===========================================================
	// Fields
	// ===========================================================

	// ===========================================================
	// Constructors
	// ===========================================================

	private DrawType(final int pUsage) {
		this.mUsage = pUsage;
	}

	// ===========================================================
	// Getter & Setter
	// ===========================================================

	public int getUsage() {
		return this.mUsage;
	}

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	// ===========================================================
	// Methods
	// ===========================================================

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================
}