/*
 * Decompiled with CFR 0.152.
 */
package org.andengine;

import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import org.andengine.opengl.view.ConfigChooser;
import org.andengine.util.exception.DeviceNotSupportedException;
import org.andengine.util.system.SystemUtils;

public class AndEngine {
    public static boolean isDeviceSupported() {
        try {
            AndEngine.checkDeviceSupported();
            return true;
        }
        catch (DeviceNotSupportedException e) {
            return false;
        }
    }

    public static void checkDeviceSupported() throws DeviceNotSupportedException {
        AndEngine.checkCodePathSupport();
        AndEngine.checkOpenGLSupport();
    }

    private static void checkCodePathSupport() throws DeviceNotSupportedException {
        if (SystemUtils.isAndroidVersionOrLower(8)) {
            try {
                System.loadLibrary("andengine");
            }
            catch (UnsatisfiedLinkError e) {
                throw new DeviceNotSupportedException(DeviceNotSupportedException.DeviceNotSupportedCause.CODEPATH_INCOMPLETE, (Throwable)e);
            }
        }
    }

    private static void checkOpenGLSupport() throws DeviceNotSupportedException {
        AndEngine.checkEGLConfigChooserSupport();
    }

    private static void checkEGLConfigChooserSupport() throws DeviceNotSupportedException {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLDisplay eglDisplay = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] version = new int[2];
        egl.eglInitialize(eglDisplay, version);
        ConfigChooser configChooser = new ConfigChooser(false);
        try {
            configChooser.chooseConfig(egl, eglDisplay);
        }
        catch (IllegalArgumentException e) {
            throw new DeviceNotSupportedException(DeviceNotSupportedException.DeviceNotSupportedCause.EGLCONFIG_NOT_FOUND, (Throwable)e);
        }
    }
}

