/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.audio;

import java.util.ArrayList;
import org.andengine.audio.IAudioEntity;
import org.andengine.audio.IAudioManager;

public abstract class BaseAudioManager<T extends IAudioEntity>
implements IAudioManager<T> {
    protected final ArrayList<T> mAudioEntities = new ArrayList();
    protected float mMasterVolume = 1.0f;

    @Override
    public float getMasterVolume() {
        return this.mMasterVolume;
    }

    @Override
    public void setMasterVolume(float pMasterVolume) {
        this.mMasterVolume = pMasterVolume;
        ArrayList<T> audioEntities = this.mAudioEntities;
        for (int i = audioEntities.size() - 1; i >= 0; --i) {
            IAudioEntity audioEntity = (IAudioEntity)audioEntities.get(i);
            audioEntity.onMasterVolumeChanged(pMasterVolume);
        }
    }

    @Override
    public void add(T pAudioEntity) {
        this.mAudioEntities.add(pAudioEntity);
    }

    @Override
    public boolean remove(T pAudioEntity) {
        return this.mAudioEntities.remove(pAudioEntity);
    }

    @Override
    public void releaseAll() {
        ArrayList<T> audioEntities = this.mAudioEntities;
        for (int i = audioEntities.size() - 1; i >= 0; --i) {
            IAudioEntity audioEntity = (IAudioEntity)audioEntities.get(i);
            audioEntity.stop();
            audioEntity.release();
        }
    }
}

