/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.audio.music;

import android.media.MediaPlayer;
import org.andengine.audio.BaseAudioEntity;
import org.andengine.audio.music.MusicManager;
import org.andengine.audio.music.exception.MusicReleasedException;

public class Music
extends BaseAudioEntity {
    private MediaPlayer mMediaPlayer;

    Music(MusicManager pMusicManager, MediaPlayer pMediaPlayer) {
        super(pMusicManager);
        this.mMediaPlayer = pMediaPlayer;
    }

    public boolean isPlaying() throws MusicReleasedException {
        this.assertNotReleased();
        return this.mMediaPlayer.isPlaying();
    }

    public MediaPlayer getMediaPlayer() throws MusicReleasedException {
        this.assertNotReleased();
        return this.mMediaPlayer;
    }

    protected MusicManager getAudioManager() throws MusicReleasedException {
        return (MusicManager)super.getAudioManager();
    }

    @Override
    protected void throwOnReleased() throws MusicReleasedException {
        throw new MusicReleasedException();
    }

    @Override
    public void play() throws MusicReleasedException {
        super.play();
        this.mMediaPlayer.start();
    }

    @Override
    public void stop() throws MusicReleasedException {
        super.stop();
        this.mMediaPlayer.stop();
    }

    @Override
    public void resume() throws MusicReleasedException {
        super.resume();
        this.mMediaPlayer.start();
    }

    @Override
    public void pause() throws MusicReleasedException {
        super.pause();
        this.mMediaPlayer.pause();
    }

    @Override
    public void setLooping(boolean pLooping) throws MusicReleasedException {
        super.setLooping(pLooping);
        this.mMediaPlayer.setLooping(pLooping);
    }

    @Override
    public void setVolume(float pLeftVolume, float pRightVolume) throws MusicReleasedException {
        super.setVolume(pLeftVolume, pRightVolume);
        float masterVolume = this.getAudioManager().getMasterVolume();
        float actualLeftVolume = pLeftVolume * masterVolume;
        float actualRightVolume = pRightVolume * masterVolume;
        this.mMediaPlayer.setVolume(actualLeftVolume, actualRightVolume);
    }

    @Override
    public void onMasterVolumeChanged(float pMasterVolume) throws MusicReleasedException {
        this.setVolume(this.mLeftVolume, this.mRightVolume);
    }

    @Override
    public void release() throws MusicReleasedException {
        this.assertNotReleased();
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.getAudioManager().remove(this);
        super.release();
    }

    public void seekTo(int pMilliseconds) throws MusicReleasedException {
        this.assertNotReleased();
        this.mMediaPlayer.seekTo(pMilliseconds);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener pOnCompletionListener) throws MusicReleasedException {
        this.assertNotReleased();
        this.mMediaPlayer.setOnCompletionListener(pOnCompletionListener);
    }
}

