/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.audio.sound;

import android.media.SoundPool;
import org.andengine.audio.BaseAudioEntity;
import org.andengine.audio.sound.SoundManager;
import org.andengine.audio.sound.exception.SoundReleasedException;

public class Sound
extends BaseAudioEntity {
    private int mSoundID;
    private int mStreamID;
    private boolean mLoaded;
    private int mLoopCount;
    private float mRate = 1.0f;

    Sound(SoundManager pSoundManager, int pSoundID) {
        super(pSoundManager);
        this.mSoundID = pSoundID;
    }

    public int getSoundID() {
        return this.mSoundID;
    }

    public int getStreamID() {
        return this.mStreamID;
    }

    public boolean isLoaded() {
        return this.mLoaded;
    }

    public void setLoaded(boolean pLoaded) {
        this.mLoaded = pLoaded;
    }

    public void setLoopCount(int pLoopCount) throws SoundReleasedException {
        this.assertNotReleased();
        this.mLoopCount = pLoopCount;
        if (this.mStreamID != 0) {
            this.getSoundPool().setLoop(this.mStreamID, pLoopCount);
        }
    }

    public float getRate() {
        return this.mRate;
    }

    public void setRate(float pRate) throws SoundReleasedException {
        this.assertNotReleased();
        this.mRate = pRate;
        if (this.mStreamID != 0) {
            this.getSoundPool().setRate(this.mStreamID, pRate);
        }
    }

    private SoundPool getSoundPool() throws SoundReleasedException {
        return this.getAudioManager().getSoundPool();
    }

    protected SoundManager getAudioManager() throws SoundReleasedException {
        return (SoundManager)super.getAudioManager();
    }

    @Override
    protected void throwOnReleased() throws SoundReleasedException {
        throw new SoundReleasedException();
    }

    @Override
    public void play() throws SoundReleasedException {
        super.play();
        float masterVolume = this.getMasterVolume();
        float leftVolume = this.mLeftVolume * masterVolume;
        float rightVolume = this.mRightVolume * masterVolume;
        this.mStreamID = this.getSoundPool().play(this.mSoundID, leftVolume, rightVolume, 1, this.mLoopCount, this.mRate);
    }

    @Override
    public void stop() throws SoundReleasedException {
        super.stop();
        if (this.mStreamID != 0) {
            this.getSoundPool().stop(this.mStreamID);
        }
    }

    @Override
    public void resume() throws SoundReleasedException {
        super.resume();
        if (this.mStreamID != 0) {
            this.getSoundPool().resume(this.mStreamID);
        }
    }

    @Override
    public void pause() throws SoundReleasedException {
        super.pause();
        if (this.mStreamID != 0) {
            this.getSoundPool().pause(this.mStreamID);
        }
    }

    @Override
    public void release() throws SoundReleasedException {
        this.assertNotReleased();
        this.getSoundPool().unload(this.mSoundID);
        this.mSoundID = 0;
        this.mLoaded = false;
        this.getAudioManager().remove(this);
        super.release();
    }

    @Override
    public void setLooping(boolean pLooping) throws SoundReleasedException {
        super.setLooping(pLooping);
        this.setLoopCount(pLooping ? -1 : 0);
    }

    @Override
    public void setVolume(float pLeftVolume, float pRightVolume) throws SoundReleasedException {
        super.setVolume(pLeftVolume, pRightVolume);
        if (this.mStreamID != 0) {
            float masterVolume = this.getMasterVolume();
            float leftVolume = this.mLeftVolume * masterVolume;
            float rightVolume = this.mRightVolume * masterVolume;
            this.getSoundPool().setVolume(this.mStreamID, leftVolume, rightVolume);
        }
    }

    @Override
    public void onMasterVolumeChanged(float pMasterVolume) throws SoundReleasedException {
        this.setVolume(this.mLeftVolume, this.mRightVolume);
    }
}

