/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.audio.sound;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import org.andengine.audio.sound.Sound;
import org.andengine.audio.sound.SoundManager;

public class SoundFactory {
    private static String sAssetBasePath = "";

    public static void setAssetBasePath(String pAssetBasePath) {
        if (!pAssetBasePath.endsWith("/") && pAssetBasePath.length() != 0) {
            throw new IllegalStateException("pAssetBasePath must end with '/' or be lenght zero.");
        }
        sAssetBasePath = pAssetBasePath;
    }

    public static String getAssetBasePath() {
        return sAssetBasePath;
    }

    public static void onCreate() {
        SoundFactory.setAssetBasePath("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sound createSoundFromPath(SoundManager pSoundManager, String pPath) {
        SoundManager soundManager = pSoundManager;
        synchronized (soundManager) {
            int soundID = pSoundManager.getSoundPool().load(pPath, 1);
            Sound sound = new Sound(pSoundManager, soundID);
            pSoundManager.add(sound);
            return sound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sound createSoundFromAsset(SoundManager pSoundManager, Context pContext, String pAssetPath) throws IOException {
        SoundManager soundManager = pSoundManager;
        synchronized (soundManager) {
            int soundID = pSoundManager.getSoundPool().load(pContext.getAssets().openFd(sAssetBasePath + pAssetPath), 1);
            Sound sound = new Sound(pSoundManager, soundID);
            pSoundManager.add(sound);
            return sound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sound createSoundFromResource(SoundManager pSoundManager, Context pContext, int pSoundResID) {
        SoundManager soundManager = pSoundManager;
        synchronized (soundManager) {
            int soundID = pSoundManager.getSoundPool().load(pContext, pSoundResID, 1);
            Sound sound = new Sound(pSoundManager, soundID);
            pSoundManager.add(sound);
            return sound;
        }
    }

    public static Sound createSoundFromFile(SoundManager pSoundManager, File pFile) {
        return SoundFactory.createSoundFromPath(pSoundManager, pFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sound createSoundFromAssetFileDescriptor(SoundManager pSoundManager, AssetFileDescriptor pAssetFileDescriptor) {
        SoundManager soundManager = pSoundManager;
        synchronized (soundManager) {
            int soundID = pSoundManager.getSoundPool().load(pAssetFileDescriptor, 1);
            Sound sound = new Sound(pSoundManager, soundID);
            pSoundManager.add(sound);
            return sound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sound createSoundFromFileDescriptor(SoundManager pSoundManager, FileDescriptor pFileDescriptor, long pOffset, long pLength) {
        SoundManager soundManager = pSoundManager;
        synchronized (soundManager) {
            int soundID = pSoundManager.getSoundPool().load(pFileDescriptor, pOffset, pLength, 1);
            Sound sound = new Sound(pSoundManager, soundID);
            pSoundManager.add(sound);
            return sound;
        }
    }
}

