/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Process;
import android.os.Vibrator;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.andengine.audio.music.MusicFactory;
import org.andengine.audio.music.MusicManager;
import org.andengine.audio.sound.SoundFactory;
import org.andengine.audio.sound.SoundManager;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.handler.DrawHandlerList;
import org.andengine.engine.handler.IDrawHandler;
import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.engine.handler.UpdateHandlerList;
import org.andengine.engine.handler.runnable.RunnableHandler;
import org.andengine.engine.options.EngineOptions;
import org.andengine.entity.scene.Scene;
import org.andengine.input.sensor.SensorDelay;
import org.andengine.input.sensor.acceleration.AccelerationData;
import org.andengine.input.sensor.acceleration.AccelerationSensorOptions;
import org.andengine.input.sensor.acceleration.IAccelerationListener;
import org.andengine.input.sensor.location.ILocationListener;
import org.andengine.input.sensor.location.LocationProviderStatus;
import org.andengine.input.sensor.location.LocationSensorOptions;
import org.andengine.input.sensor.orientation.IOrientationListener;
import org.andengine.input.sensor.orientation.OrientationData;
import org.andengine.input.sensor.orientation.OrientationSensorOptions;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.controller.ITouchController;
import org.andengine.input.touch.controller.ITouchEventCallback;
import org.andengine.input.touch.controller.MultiTouchController;
import org.andengine.input.touch.controller.SingleTouchController;
import org.andengine.opengl.font.FontFactory;
import org.andengine.opengl.font.FontManager;
import org.andengine.opengl.shader.ShaderProgramManager;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.util.debug.Debug;

public class Engine
implements SensorEventListener,
View.OnTouchListener,
ITouchEventCallback,
LocationListener {
    private static final SensorDelay SENSORDELAY_DEFAULT = SensorDelay.GAME;
    private static final int UPDATEHANDLERS_CAPACITY_DEFAULT = 8;
    private static final int DRAWHANDLERS_CAPACITY_DEFAULT = 4;
    private boolean mRunning;
    private boolean mDestroyed;
    private long mLastTick;
    private float mSecondsElapsedTotal;
    private final EngineLock mEngineLock;
    private final UpdateThread mUpdateThread;
    private final RunnableHandler mUpdateThreadRunnableHandler = new RunnableHandler();
    private final EngineOptions mEngineOptions;
    protected final Camera mCamera;
    private ITouchController mTouchController;
    private final VertexBufferObjectManager mVertexBufferObjectManager = new VertexBufferObjectManager();
    private final TextureManager mTextureManager = new TextureManager();
    private final FontManager mFontManager = new FontManager();
    private final ShaderProgramManager mShaderProgramManager = new ShaderProgramManager();
    private final SoundManager mSoundManager;
    private final MusicManager mMusicManager;
    protected Scene mScene;
    private Vibrator mVibrator;
    private ILocationListener mLocationListener;
    private Location mLocation;
    private IAccelerationListener mAccelerationListener;
    private AccelerationData mAccelerationData;
    private IOrientationListener mOrientationListener;
    private OrientationData mOrientationData;
    private final UpdateHandlerList mUpdateHandlers = new UpdateHandlerList(8);
    private final DrawHandlerList mDrawHandlers = new DrawHandlerList(4);
    protected int mSurfaceWidth = 1;
    protected int mSurfaceHeight = 1;

    public Engine(EngineOptions pEngineOptions) {
        BitmapTextureAtlasTextureRegionFactory.reset();
        SoundFactory.onCreate();
        MusicFactory.onCreate();
        FontFactory.onCreate();
        this.mVertexBufferObjectManager.onCreate();
        this.mTextureManager.onCreate();
        this.mFontManager.onCreate();
        this.mShaderProgramManager.onCreate();
        this.mEngineOptions = pEngineOptions;
        this.mEngineLock = this.mEngineOptions.hasEngineLock() ? pEngineOptions.getEngineLock() : new EngineLock(false);
        this.mCamera = pEngineOptions.getCamera();
        if (this.mEngineOptions.getTouchOptions().needsMultiTouch()) {
            this.setTouchController(new MultiTouchController());
        } else {
            this.setTouchController(new SingleTouchController());
        }
        this.mSoundManager = this.mEngineOptions.getAudioOptions().needsSound() ? new SoundManager(this.mEngineOptions.getAudioOptions().getSoundOptions().getMaxSimultaneousStreams()) : null;
        this.mMusicManager = this.mEngineOptions.getAudioOptions().needsMusic() ? new MusicManager() : null;
        this.mUpdateThread = this.mEngineOptions.hasUpdateThread() ? this.mEngineOptions.getUpdateThread() : new UpdateThread();
        this.mUpdateThread.setEngine(this);
    }

    public void startUpdateThread() throws IllegalThreadStateException {
        this.mUpdateThread.start();
    }

    public synchronized boolean isRunning() {
        return this.mRunning;
    }

    public synchronized void start() {
        if (!this.mRunning) {
            this.mLastTick = System.nanoTime();
            this.mRunning = true;
        }
    }

    public synchronized void stop() {
        if (this.mRunning) {
            this.mRunning = false;
        }
    }

    public EngineLock getEngineLock() {
        return this.mEngineLock;
    }

    public Scene getScene() {
        return this.mScene;
    }

    public void setScene(Scene pScene) {
        this.mScene = pScene;
    }

    public EngineOptions getEngineOptions() {
        return this.mEngineOptions;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public float getSecondsElapsedTotal() {
        return this.mSecondsElapsedTotal;
    }

    public void setSurfaceSize(int pSurfaceWidth, int pSurfaceHeight) {
        this.mSurfaceWidth = pSurfaceWidth;
        this.mSurfaceHeight = pSurfaceHeight;
        this.onUpdateCameraSurface();
    }

    protected void onUpdateCameraSurface() {
        this.mCamera.setSurfaceSize(0, 0, this.mSurfaceWidth, this.mSurfaceHeight);
    }

    public int getSurfaceWidth() {
        return this.mSurfaceWidth;
    }

    public int getSurfaceHeight() {
        return this.mSurfaceHeight;
    }

    public ITouchController getTouchController() {
        return this.mTouchController;
    }

    public void setTouchController(ITouchController pTouchController) {
        this.mTouchController = pTouchController;
        this.mTouchController.setTouchEventCallback(this);
    }

    public AccelerationData getAccelerationData() {
        return this.mAccelerationData;
    }

    public OrientationData getOrientationData() {
        return this.mOrientationData;
    }

    public VertexBufferObjectManager getVertexBufferObjectManager() {
        return this.mVertexBufferObjectManager;
    }

    public TextureManager getTextureManager() {
        return this.mTextureManager;
    }

    public FontManager getFontManager() {
        return this.mFontManager;
    }

    public ShaderProgramManager getShaderProgramManager() {
        return this.mShaderProgramManager;
    }

    public SoundManager getSoundManager() throws IllegalStateException {
        if (this.mSoundManager != null) {
            return this.mSoundManager;
        }
        throw new IllegalStateException("To enable the SoundManager, check the EngineOptions!");
    }

    public MusicManager getMusicManager() throws IllegalStateException {
        if (this.mMusicManager != null) {
            return this.mMusicManager;
        }
        throw new IllegalStateException("To enable the MusicManager, check the EngineOptions!");
    }

    public void registerUpdateHandler(IUpdateHandler pUpdateHandler) {
        this.mUpdateHandlers.add(pUpdateHandler);
    }

    public void unregisterUpdateHandler(IUpdateHandler pUpdateHandler) {
        this.mUpdateHandlers.remove(pUpdateHandler);
    }

    public void clearUpdateHandlers() {
        this.mUpdateHandlers.clear();
    }

    public void registerDrawHandler(IDrawHandler pDrawHandler) {
        this.mDrawHandlers.add(pDrawHandler);
    }

    public void unregisterDrawHandler(IDrawHandler pDrawHandler) {
        this.mDrawHandlers.remove(pDrawHandler);
    }

    public void clearDrawHandlers() {
        this.mDrawHandlers.clear();
    }

    public void onAccuracyChanged(Sensor pSensor, int pAccuracy) {
        if (this.mRunning) {
            switch (pSensor.getType()) {
                case 1: {
                    if (this.mAccelerationData != null) {
                        this.mAccelerationData.setAccuracy(pAccuracy);
                        this.mAccelerationListener.onAccelerationAccuracyChanged(this.mAccelerationData);
                        break;
                    }
                    if (this.mOrientationData == null) break;
                    this.mOrientationData.setAccelerationAccuracy(pAccuracy);
                    this.mOrientationListener.onOrientationAccuracyChanged(this.mOrientationData);
                    break;
                }
                case 2: {
                    this.mOrientationData.setMagneticFieldAccuracy(pAccuracy);
                    this.mOrientationListener.onOrientationAccuracyChanged(this.mOrientationData);
                }
            }
        }
    }

    public void onSensorChanged(SensorEvent pEvent) {
        if (this.mRunning) {
            switch (pEvent.sensor.getType()) {
                case 1: {
                    if (this.mAccelerationData != null) {
                        this.mAccelerationData.setValues(pEvent.values);
                        this.mAccelerationListener.onAccelerationChanged(this.mAccelerationData);
                        break;
                    }
                    if (this.mOrientationData == null) break;
                    this.mOrientationData.setAccelerationValues(pEvent.values);
                    this.mOrientationListener.onOrientationChanged(this.mOrientationData);
                    break;
                }
                case 2: {
                    this.mOrientationData.setMagneticFieldValues(pEvent.values);
                    this.mOrientationListener.onOrientationChanged(this.mOrientationData);
                }
            }
        }
    }

    public void onLocationChanged(Location pLocation) {
        if (this.mLocation == null) {
            this.mLocation = pLocation;
        } else if (pLocation == null) {
            this.mLocationListener.onLocationLost();
        } else {
            this.mLocation = pLocation;
            this.mLocationListener.onLocationChanged(pLocation);
        }
    }

    public void onProviderDisabled(String pProvider) {
        this.mLocationListener.onLocationProviderDisabled();
    }

    public void onProviderEnabled(String pProvider) {
        this.mLocationListener.onLocationProviderEnabled();
    }

    public void onStatusChanged(String pProvider, int pStatus, Bundle pExtras) {
        switch (pStatus) {
            case 2: {
                this.mLocationListener.onLocationProviderStatusChanged(LocationProviderStatus.AVAILABLE, pExtras);
                break;
            }
            case 0: {
                this.mLocationListener.onLocationProviderStatusChanged(LocationProviderStatus.OUT_OF_SERVICE, pExtras);
                break;
            }
            case 1: {
                this.mLocationListener.onLocationProviderStatusChanged(LocationProviderStatus.TEMPORARILY_UNAVAILABLE, pExtras);
            }
        }
    }

    public boolean onTouch(View pView, MotionEvent pSurfaceMotionEvent) {
        if (this.mRunning) {
            this.mTouchController.onHandleMotionEvent(pSurfaceMotionEvent);
            try {
                Thread.sleep(this.mEngineOptions.getTouchOptions().getTouchEventIntervalMilliseconds());
            }
            catch (InterruptedException e) {
                Debug.e(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(TouchEvent pSurfaceTouchEvent) {
        Scene scene = this.getSceneFromSurfaceTouchEvent(pSurfaceTouchEvent);
        Camera camera = this.getCameraFromSurfaceTouchEvent(pSurfaceTouchEvent);
        this.convertSurfaceToSceneTouchEvent(camera, pSurfaceTouchEvent);
        if (this.onTouchHUD(camera, pSurfaceTouchEvent)) {
            return true;
        }
        return this.onTouchScene(scene, pSurfaceTouchEvent);
    }

    protected boolean onTouchHUD(Camera pCamera, TouchEvent pSceneTouchEvent) {
        if (pCamera.hasHUD()) {
            return pCamera.getHUD().onSceneTouchEvent(pSceneTouchEvent);
        }
        return false;
    }

    protected boolean onTouchScene(Scene pScene, TouchEvent pSceneTouchEvent) {
        if (pScene != null) {
            return pScene.onSceneTouchEvent(pSceneTouchEvent);
        }
        return false;
    }

    public void runOnUpdateThread(Runnable pRunnable) {
        this.runOnUpdateThread(pRunnable, true);
    }

    public void runOnUpdateThread(Runnable pRunnable, boolean pOnlyWhenEngineRunning) {
        if (pOnlyWhenEngineRunning) {
            this.mUpdateThreadRunnableHandler.postRunnable(pRunnable);
        } else {
            this.mUpdateThread.postRunnable(pRunnable);
        }
    }

    public void runSafely(Runnable pRunnable) {
        this.mEngineLock.lock();
        try {
            pRunnable.run();
        }
        finally {
            this.mEngineLock.unlock();
        }
    }

    public void onDestroy() {
        this.mEngineLock.lock();
        try {
            this.mDestroyed = true;
            this.mEngineLock.notifyCanUpdate();
        }
        finally {
            this.mEngineLock.unlock();
        }
        try {
            this.mUpdateThread.join();
        }
        catch (InterruptedException e) {
            Debug.e("Could not join UpdateThread.", e);
            Debug.w("Trying to manually interrupt UpdateThread.");
            this.mUpdateThread.interrupt();
        }
        this.mVertexBufferObjectManager.onDestroy();
        this.mTextureManager.onDestroy();
        this.mFontManager.onDestroy();
        this.mShaderProgramManager.onDestroy();
    }

    public void onReloadResources() {
        this.mVertexBufferObjectManager.onReload();
        this.mTextureManager.onReload();
        this.mFontManager.onReload();
        this.mShaderProgramManager.onReload();
    }

    protected Camera getCameraFromSurfaceTouchEvent(TouchEvent pTouchEvent) {
        return this.getCamera();
    }

    protected Scene getSceneFromSurfaceTouchEvent(TouchEvent pTouchEvent) {
        return this.mScene;
    }

    protected void convertSurfaceToSceneTouchEvent(Camera pCamera, TouchEvent pSurfaceTouchEvent) {
        pCamera.convertSurfaceToSceneTouchEvent(pSurfaceTouchEvent, this.mSurfaceWidth, this.mSurfaceHeight);
    }

    protected void convertSceneToSurfaceTouchEvent(Camera pCamera, TouchEvent pSurfaceTouchEvent) {
        pCamera.convertSceneToSurfaceTouchEvent(pSurfaceTouchEvent, this.mSurfaceWidth, this.mSurfaceHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTickUpdate() throws InterruptedException {
        if (this.mRunning) {
            long secondsElapsed = this.getNanosecondsElapsed();
            this.mEngineLock.lock();
            try {
                this.throwOnDestroyed();
                this.onUpdate(secondsElapsed);
                this.throwOnDestroyed();
                this.mEngineLock.notifyCanDraw();
                this.mEngineLock.waitUntilCanUpdate();
            }
            finally {
                this.mEngineLock.unlock();
            }
        }
        this.mEngineLock.lock();
        try {
            this.throwOnDestroyed();
            this.mEngineLock.notifyCanDraw();
            this.mEngineLock.waitUntilCanUpdate();
        }
        finally {
            this.mEngineLock.unlock();
        }
        Thread.sleep(16L);
    }

    private void throwOnDestroyed() throws EngineDestroyedException {
        if (this.mDestroyed) {
            throw new EngineDestroyedException();
        }
    }

    public void onUpdate(long pNanosecondsElapsed) throws InterruptedException {
        float pSecondsElapsed = (float)pNanosecondsElapsed * 1.0E-9f;
        this.mSecondsElapsedTotal += pSecondsElapsed;
        this.mLastTick += pNanosecondsElapsed;
        this.mTouchController.onUpdate(pSecondsElapsed);
        this.onUpdateUpdateHandlers(pSecondsElapsed);
        this.onUpdateScene(pSecondsElapsed);
    }

    protected void onUpdateScene(float pSecondsElapsed) {
        if (this.mScene != null) {
            this.mScene.onUpdate(pSecondsElapsed);
        }
    }

    protected void onUpdateUpdateHandlers(float pSecondsElapsed) {
        this.mUpdateThreadRunnableHandler.onUpdate(pSecondsElapsed);
        this.mUpdateHandlers.onUpdate(pSecondsElapsed);
        this.getCamera().onUpdate(pSecondsElapsed);
    }

    protected void onUpdateDrawHandlers(GLState pGLState, Camera pCamera) {
        this.mDrawHandlers.onDraw(pGLState, pCamera);
    }

    public void onDrawFrame(GLState pGLState) throws InterruptedException {
        EngineLock engineLock = this.mEngineLock;
        engineLock.lock();
        try {
            engineLock.waitUntilCanDraw();
            this.mVertexBufferObjectManager.updateVertexBufferObjects(pGLState);
            this.mTextureManager.updateTextures(pGLState);
            this.mFontManager.updateFonts(pGLState);
            this.onUpdateDrawHandlers(pGLState, this.mCamera);
            this.onDrawScene(pGLState, this.mCamera);
            engineLock.notifyCanUpdate();
        }
        finally {
            engineLock.unlock();
        }
    }

    protected void onDrawScene(GLState pGLState, Camera pCamera) {
        if (this.mScene != null) {
            this.mScene.onDraw(pGLState, pCamera);
        }
        pCamera.onDrawHUD(pGLState);
    }

    private long getNanosecondsElapsed() {
        long now = System.nanoTime();
        return now - this.mLastTick;
    }

    public boolean enableVibrator(Context pContext) {
        this.mVibrator = (Vibrator)pContext.getSystemService("vibrator");
        return this.mVibrator != null;
    }

    public void vibrate(long pMilliseconds) throws IllegalStateException {
        if (this.mVibrator == null) {
            throw new IllegalStateException("You need to enable the Vibrator before you can use it!");
        }
        this.mVibrator.vibrate(pMilliseconds);
    }

    public void vibrate(long[] pPattern, int pRepeat) throws IllegalStateException {
        if (this.mVibrator == null) {
            throw new IllegalStateException("You need to enable the Vibrator before you can use it!");
        }
        this.mVibrator.vibrate(pPattern, pRepeat);
    }

    public void enableLocationSensor(Context pContext, ILocationListener pLocationListener, LocationSensorOptions pLocationSensorOptions) {
        this.mLocationListener = pLocationListener;
        LocationManager locationManager = (LocationManager)pContext.getSystemService("location");
        String locationProvider = locationManager.getBestProvider((Criteria)pLocationSensorOptions, pLocationSensorOptions.isEnabledOnly());
        locationManager.requestLocationUpdates(locationProvider, pLocationSensorOptions.getMinimumTriggerTime(), (float)pLocationSensorOptions.getMinimumTriggerDistance(), (LocationListener)this);
        this.onLocationChanged(locationManager.getLastKnownLocation(locationProvider));
    }

    public void disableLocationSensor(Context pContext) {
        LocationManager locationManager = (LocationManager)pContext.getSystemService("location");
        locationManager.removeUpdates((LocationListener)this);
    }

    public boolean enableAccelerationSensor(Context pContext, IAccelerationListener pAccelerationListener) {
        return this.enableAccelerationSensor(pContext, pAccelerationListener, new AccelerationSensorOptions(SENSORDELAY_DEFAULT));
    }

    public boolean enableAccelerationSensor(Context pContext, IAccelerationListener pAccelerationListener, AccelerationSensorOptions pAccelerationSensorOptions) {
        SensorManager sensorManager = (SensorManager)pContext.getSystemService("sensor");
        if (Engine.isSensorSupported(sensorManager, 1)) {
            this.mAccelerationListener = pAccelerationListener;
            if (this.mAccelerationData == null) {
                Display display = ((WindowManager)pContext.getSystemService("window")).getDefaultDisplay();
                int displayRotation = display.getOrientation();
                this.mAccelerationData = new AccelerationData(displayRotation);
            }
            this.registerSelfAsSensorListener(sensorManager, 1, pAccelerationSensorOptions.getSensorDelay());
            return true;
        }
        return false;
    }

    public boolean disableAccelerationSensor(Context pContext) {
        SensorManager sensorManager = (SensorManager)pContext.getSystemService("sensor");
        if (Engine.isSensorSupported(sensorManager, 1)) {
            this.unregisterSelfAsSensorListener(sensorManager, 1);
            return true;
        }
        return false;
    }

    public boolean enableOrientationSensor(Context pContext, IOrientationListener pOrientationListener) {
        return this.enableOrientationSensor(pContext, pOrientationListener, new OrientationSensorOptions(SENSORDELAY_DEFAULT));
    }

    public boolean enableOrientationSensor(Context pContext, IOrientationListener pOrientationListener, OrientationSensorOptions pOrientationSensorOptions) {
        SensorManager sensorManager = (SensorManager)pContext.getSystemService("sensor");
        if (Engine.isSensorSupported(sensorManager, 1) && Engine.isSensorSupported(sensorManager, 2)) {
            this.mOrientationListener = pOrientationListener;
            if (this.mOrientationData == null) {
                Display display = ((WindowManager)pContext.getSystemService("window")).getDefaultDisplay();
                int displayRotation = display.getOrientation();
                this.mOrientationData = new OrientationData(displayRotation);
            }
            this.registerSelfAsSensorListener(sensorManager, 1, pOrientationSensorOptions.getSensorDelay());
            this.registerSelfAsSensorListener(sensorManager, 2, pOrientationSensorOptions.getSensorDelay());
            return true;
        }
        return false;
    }

    public boolean disableOrientationSensor(Context pContext) {
        SensorManager sensorManager = (SensorManager)pContext.getSystemService("sensor");
        if (Engine.isSensorSupported(sensorManager, 1) && Engine.isSensorSupported(sensorManager, 2)) {
            this.unregisterSelfAsSensorListener(sensorManager, 1);
            this.unregisterSelfAsSensorListener(sensorManager, 2);
            return true;
        }
        return false;
    }

    private static boolean isSensorSupported(SensorManager pSensorManager, int pType) {
        return pSensorManager.getSensorList(pType).size() > 0;
    }

    private void registerSelfAsSensorListener(SensorManager pSensorManager, int pType, SensorDelay pSensorDelay) {
        Sensor sensor = (Sensor)pSensorManager.getSensorList(pType).get(0);
        pSensorManager.registerListener((SensorEventListener)this, sensor, pSensorDelay.getDelay());
    }

    private void unregisterSelfAsSensorListener(SensorManager pSensorManager, int pType) {
        Sensor sensor = (Sensor)pSensorManager.getSensorList(pType).get(0);
        pSensorManager.unregisterListener((SensorEventListener)this, sensor);
    }

    public static class EngineLock
    extends ReentrantLock {
        private static final long serialVersionUID = 671220941302523934L;
        final Condition mDrawingCondition = this.newCondition();
        final AtomicBoolean mDrawing = new AtomicBoolean(false);

        public EngineLock(boolean pFair) {
            super(pFair);
        }

        void notifyCanDraw() {
            this.mDrawing.set(true);
            this.mDrawingCondition.signalAll();
        }

        void notifyCanUpdate() {
            this.mDrawing.set(false);
            this.mDrawingCondition.signalAll();
        }

        void waitUntilCanDraw() throws InterruptedException {
            while (!this.mDrawing.get()) {
                this.mDrawingCondition.await();
            }
        }

        void waitUntilCanUpdate() throws InterruptedException {
            while (this.mDrawing.get()) {
                this.mDrawingCondition.await();
            }
        }
    }

    public class EngineDestroyedException
    extends InterruptedException {
        private static final long serialVersionUID = -4691263961728972560L;
    }

    public static class UpdateThread
    extends Thread {
        private Engine mEngine;
        private final RunnableHandler mRunnableHandler = new RunnableHandler();

        public UpdateThread() {
            super(UpdateThread.class.getSimpleName());
        }

        public void setEngine(Engine pEngine) {
            this.mEngine = pEngine;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)this.mEngine.getEngineOptions().getUpdateThreadPriority());
            try {
                while (true) {
                    this.mRunnableHandler.onUpdate(0.0f);
                    this.mEngine.onTickUpdate();
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
                return;
            }
        }

        public void postRunnable(Runnable pRunnable) {
            this.mRunnableHandler.postRunnable(pRunnable);
        }
    }
}

