/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine;

import org.andengine.engine.Engine;
import org.andengine.engine.options.EngineOptions;

public class FixedStepEngine
extends Engine {
    private final long mStepLength;
    private long mSecondsElapsedAccumulator;

    public FixedStepEngine(EngineOptions pEngineOptions, int pStepsPerSecond) {
        super(pEngineOptions);
        this.mStepLength = 1000000000L / (long)pStepsPerSecond;
    }

    @Override
    public void onUpdate(long pNanosecondsElapsed) throws InterruptedException {
        this.mSecondsElapsedAccumulator += pNanosecondsElapsed;
        long stepLength = this.mStepLength;
        while (this.mSecondsElapsedAccumulator >= stepLength) {
            super.onUpdate(stepLength);
            this.mSecondsElapsedAccumulator -= stepLength;
        }
    }
}

