/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine;

import org.andengine.engine.Engine;
import org.andengine.engine.options.EngineOptions;

public class LimitedFPSEngine
extends Engine {
    private final long mPreferredFrameLengthNanoseconds;

    public LimitedFPSEngine(EngineOptions pEngineOptions, int pFramesPerSecond) {
        super(pEngineOptions);
        this.mPreferredFrameLengthNanoseconds = 1000000000L / (long)pFramesPerSecond;
    }

    @Override
    public void onUpdate(long pNanosecondsElapsed) throws InterruptedException {
        long preferredFrameLengthNanoseconds = this.mPreferredFrameLengthNanoseconds;
        long deltaFrameLengthNanoseconds = preferredFrameLengthNanoseconds - pNanosecondsElapsed;
        if (deltaFrameLengthNanoseconds <= 0L) {
            super.onUpdate(pNanosecondsElapsed);
        } else {
            int sleepTimeMilliseconds = (int)(deltaFrameLengthNanoseconds / 1000000L);
            Thread.sleep(sleepTimeMilliseconds);
            super.onUpdate(pNanosecondsElapsed + deltaFrameLengthNanoseconds);
        }
    }
}

