/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera;

import org.andengine.engine.camera.Camera;

public class BoundCamera
extends Camera {
    protected boolean mBoundsEnabled;
    protected float mBoundsXMin;
    protected float mBoundsXMax;
    protected float mBoundsYMin;
    protected float mBoundsYMax;
    protected float mBoundsCenterX;
    protected float mBoundsCenterY;
    protected float mBoundsWidth;
    protected float mBoundsHeight;

    public BoundCamera(float pX, float pY, float pWidth, float pHeight) {
        super(pX, pY, pWidth, pHeight);
    }

    public BoundCamera(float pX, float pY, float pWidth, float pHeight, float pBoundMinX, float pBoundMaxX, float pBoundMinY, float pBoundMaxY) {
        super(pX, pY, pWidth, pHeight);
        this.setBounds(pBoundMinX, pBoundMinY, pBoundMaxX, pBoundMaxY);
        this.mBoundsEnabled = true;
    }

    public boolean isBoundsEnabled() {
        return this.mBoundsEnabled;
    }

    public void setBoundsEnabled(boolean pBoundsEnabled) {
        this.mBoundsEnabled = pBoundsEnabled;
    }

    public void setBounds(float pBoundsXMin, float pBoundsYMin, float pBoundsXMax, float pBoundsYMax) {
        this.mBoundsXMin = pBoundsXMin;
        this.mBoundsXMax = pBoundsXMax;
        this.mBoundsYMin = pBoundsYMin;
        this.mBoundsYMax = pBoundsYMax;
        this.mBoundsWidth = this.mBoundsXMax - this.mBoundsXMin;
        this.mBoundsHeight = this.mBoundsYMax - this.mBoundsYMin;
        this.mBoundsCenterX = this.mBoundsXMin + this.mBoundsWidth * 0.5f;
        this.mBoundsCenterY = this.mBoundsYMin + this.mBoundsHeight * 0.5f;
    }

    public float getBoundsXMin() {
        return this.mBoundsXMin;
    }

    public float getBoundsXMax() {
        return this.mBoundsXMax;
    }

    public float getBoundsYMin() {
        return this.mBoundsYMin;
    }

    public float getBoundsYMax() {
        return this.mBoundsYMax;
    }

    public float getBoundsWidth() {
        return this.mBoundsWidth;
    }

    public float getBoundsHeight() {
        return this.mBoundsHeight;
    }

    @Override
    public void setCenter(float pCenterX, float pCenterY) {
        super.setCenter(pCenterX, pCenterY);
        if (this.mBoundsEnabled) {
            this.ensureInBounds();
        }
    }

    protected void ensureInBounds() {
        float centerX = this.mBoundsWidth < this.getWidth() ? this.mBoundsCenterX : this.getBoundedX(this.getCenterX());
        float centerY = this.mBoundsHeight < this.getHeight() ? this.mBoundsCenterY : this.getBoundedY(this.getCenterY());
        super.setCenter(centerX, centerY);
    }

    protected float getBoundedX(float pX) {
        boolean maxXBoundExceeded;
        float minXBoundExceededAmount = this.mBoundsXMin - this.getXMin();
        boolean minXBoundExceeded = minXBoundExceededAmount > 0.0f;
        float maxXBoundExceededAmount = this.getXMax() - this.mBoundsXMax;
        boolean bl = maxXBoundExceeded = maxXBoundExceededAmount > 0.0f;
        if (minXBoundExceeded) {
            if (maxXBoundExceeded) {
                return pX - maxXBoundExceededAmount + minXBoundExceededAmount;
            }
            return pX + minXBoundExceededAmount;
        }
        if (maxXBoundExceeded) {
            return pX - maxXBoundExceededAmount;
        }
        return pX;
    }

    protected float getBoundedY(float pY) {
        boolean maxYBoundExceeded;
        float minYBoundExceededAmount = this.mBoundsYMin - this.getYMin();
        boolean minYBoundExceeded = minYBoundExceededAmount > 0.0f;
        float maxYBoundExceededAmount = this.getYMax() - this.mBoundsYMax;
        boolean bl = maxYBoundExceeded = maxYBoundExceededAmount > 0.0f;
        if (minYBoundExceeded) {
            if (maxYBoundExceeded) {
                return pY - maxYBoundExceededAmount + minYBoundExceededAmount;
            }
            return pY + minYBoundExceededAmount;
        }
        if (maxYBoundExceeded) {
            return pY - maxYBoundExceededAmount;
        }
        return pY;
    }
}

