/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera;

import org.andengine.engine.camera.ZoomCamera;

public class SmoothCamera
extends ZoomCamera {
    protected float mMaxVelocityX;
    protected float mMaxVelocityY;
    protected float mMaxZoomFactorChange;
    protected float mTargetCenterX;
    protected float mTargetCenterY;
    protected float mTargetZoomFactor;

    public SmoothCamera(float pX, float pY, float pWidth, float pHeight, float pMaxVelocityX, float pMaxVelocityY, float pMaxZoomFactorChange) {
        super(pX, pY, pWidth, pHeight);
        this.mMaxVelocityX = pMaxVelocityX;
        this.mMaxVelocityY = pMaxVelocityY;
        this.mMaxZoomFactorChange = pMaxZoomFactorChange;
        this.mTargetCenterX = this.getCenterX();
        this.mTargetCenterY = this.getCenterY();
        this.mTargetZoomFactor = 1.0f;
    }

    public float getTargetCenterX() {
        return this.mTargetCenterX;
    }

    public float getTargetCenterY() {
        return this.mTargetCenterY;
    }

    public float getTargetZoomFactor() {
        return this.mTargetZoomFactor;
    }

    @Override
    public void setCenter(float pCenterX, float pCenterY) {
        this.mTargetCenterX = pCenterX;
        this.mTargetCenterY = pCenterY;
    }

    public void setCenterDirect(float pCenterX, float pCenterY) {
        super.setCenter(pCenterX, pCenterY);
        this.mTargetCenterX = pCenterX;
        this.mTargetCenterY = pCenterY;
    }

    @Override
    public void setZoomFactor(float pZoomFactor) {
        if (this.mTargetZoomFactor != pZoomFactor) {
            if (this.mTargetZoomFactor == this.mZoomFactor) {
                this.mTargetZoomFactor = pZoomFactor;
                this.onSmoothZoomStarted();
            } else {
                this.mTargetZoomFactor = pZoomFactor;
            }
        }
    }

    public void setZoomFactorDirect(float pZoomFactor) {
        if (this.mTargetZoomFactor != this.mZoomFactor) {
            this.mTargetZoomFactor = pZoomFactor;
            super.setZoomFactor(pZoomFactor);
            this.onSmoothZoomFinished();
        } else {
            this.mTargetZoomFactor = pZoomFactor;
            super.setZoomFactor(pZoomFactor);
        }
    }

    public float getMaxVelocityX() {
        return this.mMaxVelocityX;
    }

    public void setMaxVelocityX(float pMaxVelocityX) {
        this.mMaxVelocityX = pMaxVelocityX;
    }

    public float getMaxVelocityY() {
        return this.mMaxVelocityY;
    }

    public void setMaxVelocityY(float pMaxVelocityY) {
        this.mMaxVelocityY = pMaxVelocityY;
    }

    public void setMaxVelocity(float pMaxVelocityX, float pMaxVelocityY) {
        this.mMaxVelocityX = pMaxVelocityX;
        this.mMaxVelocityY = pMaxVelocityY;
    }

    public float getMaxZoomFactorChange() {
        return this.mMaxZoomFactorChange;
    }

    public void setMaxZoomFactorChange(float pMaxZoomFactorChange) {
        this.mMaxZoomFactorChange = pMaxZoomFactorChange;
    }

    protected void onSmoothZoomStarted() {
    }

    protected void onSmoothZoomFinished() {
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        float targetZoomFactor;
        float currentZoom;
        super.onUpdate(pSecondsElapsed);
        float currentCenterX = this.getCenterX();
        float currentCenterY = this.getCenterY();
        float targetCenterX = this.mTargetCenterX;
        float targetCenterY = this.mTargetCenterY;
        if (currentCenterX != targetCenterX || currentCenterY != targetCenterY) {
            float diffX = targetCenterX - currentCenterX;
            float dX = this.limitToMaxVelocityX(diffX, pSecondsElapsed);
            float diffY = targetCenterY - currentCenterY;
            float dY = this.limitToMaxVelocityY(diffY, pSecondsElapsed);
            super.setCenter(currentCenterX + dX, currentCenterY + dY);
        }
        if ((currentZoom = this.getZoomFactor()) != (targetZoomFactor = this.mTargetZoomFactor)) {
            float absoluteZoomDifference = targetZoomFactor - currentZoom;
            float zoomChange = this.limitToMaxZoomFactorChange(absoluteZoomDifference, pSecondsElapsed);
            super.setZoomFactor(currentZoom + zoomChange);
            if (this.mZoomFactor == this.mTargetZoomFactor) {
                this.onSmoothZoomFinished();
            }
        }
    }

    private float limitToMaxVelocityX(float pValue, float pSecondsElapsed) {
        if (pValue > 0.0f) {
            return Math.min(pValue, this.mMaxVelocityX * pSecondsElapsed);
        }
        return Math.max(pValue, -this.mMaxVelocityX * pSecondsElapsed);
    }

    private float limitToMaxVelocityY(float pValue, float pSecondsElapsed) {
        if (pValue > 0.0f) {
            return Math.min(pValue, this.mMaxVelocityY * pSecondsElapsed);
        }
        return Math.max(pValue, -this.mMaxVelocityY * pSecondsElapsed);
    }

    private float limitToMaxZoomFactorChange(float pValue, float pSecondsElapsed) {
        if (pValue > 0.0f) {
            return Math.min(pValue, this.mMaxZoomFactorChange * pSecondsElapsed);
        }
        return Math.max(pValue, -this.mMaxZoomFactorChange * pSecondsElapsed);
    }
}

