/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera;

import org.andengine.engine.camera.BoundCamera;
import org.andengine.engine.camera.Camera;
import org.andengine.input.touch.TouchEvent;
import org.andengine.util.math.MathUtils;

public class ZoomCamera
extends BoundCamera {
    protected float mZoomFactor = 1.0f;

    public ZoomCamera(float pX, float pY, float pWidth, float pHeight) {
        super(pX, pY, pWidth, pHeight);
    }

    public float getZoomFactor() {
        return this.mZoomFactor;
    }

    public void setZoomFactor(float pZoomFactor) {
        this.mZoomFactor = pZoomFactor;
        if (this.mBoundsEnabled) {
            this.ensureInBounds();
        }
    }

    @Override
    public float getXMin() {
        if (this.mZoomFactor == 1.0f) {
            return super.getXMin();
        }
        float centerX = this.getCenterX();
        return centerX - (centerX - super.getXMin()) / this.mZoomFactor;
    }

    @Override
    public float getXMax() {
        if (this.mZoomFactor == 1.0f) {
            return super.getXMax();
        }
        float centerX = this.getCenterX();
        return centerX + (super.getXMax() - centerX) / this.mZoomFactor;
    }

    @Override
    public float getYMin() {
        if (this.mZoomFactor == 1.0f) {
            return super.getYMin();
        }
        float centerY = this.getCenterY();
        return centerY - (centerY - super.getYMin()) / this.mZoomFactor;
    }

    @Override
    public float getYMax() {
        if (this.mZoomFactor == 1.0f) {
            return super.getYMax();
        }
        float centerY = this.getCenterY();
        return centerY + (super.getYMax() - centerY) / this.mZoomFactor;
    }

    @Override
    public float getWidth() {
        return super.getWidth() / this.mZoomFactor;
    }

    @Override
    public float getHeight() {
        return super.getHeight() / this.mZoomFactor;
    }

    @Override
    protected void applySceneToCameraSceneOffset(TouchEvent pSceneTouchEvent) {
        float zoomFactor = this.mZoomFactor;
        if (zoomFactor != 1.0f) {
            Camera.VERTICES_TMP[0] = pSceneTouchEvent.getX();
            Camera.VERTICES_TMP[1] = pSceneTouchEvent.getY();
            MathUtils.scaleAroundCenter(Camera.VERTICES_TMP, zoomFactor, zoomFactor, this.getCenterX(), this.getCenterY());
            pSceneTouchEvent.set(Camera.VERTICES_TMP[0], Camera.VERTICES_TMP[1]);
        }
        super.applySceneToCameraSceneOffset(pSceneTouchEvent);
    }

    @Override
    protected void applySceneToCameraSceneOffset(float[] pSceneCoordinates) {
        float zoomFactor = this.mZoomFactor;
        if (zoomFactor != 1.0f) {
            MathUtils.scaleAroundCenter(pSceneCoordinates, zoomFactor, zoomFactor, this.getCenterX(), this.getCenterY());
        }
        super.applySceneToCameraSceneOffset(pSceneCoordinates);
    }

    @Override
    protected void unapplySceneToCameraSceneOffset(TouchEvent pCameraSceneTouchEvent) {
        super.unapplySceneToCameraSceneOffset(pCameraSceneTouchEvent);
        float zoomFactor = this.mZoomFactor;
        if (zoomFactor != 1.0f) {
            Camera.VERTICES_TMP[0] = pCameraSceneTouchEvent.getX();
            Camera.VERTICES_TMP[1] = pCameraSceneTouchEvent.getY();
            MathUtils.revertScaleAroundCenter(Camera.VERTICES_TMP, zoomFactor, zoomFactor, this.getCenterX(), this.getCenterY());
            pCameraSceneTouchEvent.set(Camera.VERTICES_TMP[0], Camera.VERTICES_TMP[1]);
        }
    }

    @Override
    protected void unapplySceneToCameraSceneOffset(float[] pCameraSceneCoordinates) {
        super.unapplySceneToCameraSceneOffset(pCameraSceneCoordinates);
        float zoomFactor = this.mZoomFactor;
        if (zoomFactor != 1.0f) {
            MathUtils.revertScaleAroundCenter(pCameraSceneCoordinates, zoomFactor, zoomFactor, this.getCenterX(), this.getCenterY());
        }
    }
}

