/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera.hud.controls;

import org.andengine.engine.camera.Camera;
import org.andengine.engine.camera.hud.controls.BaseOnScreenControl;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.ClickDetector;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.util.math.MathUtils;

public class AnalogOnScreenControl
extends BaseOnScreenControl
implements ClickDetector.IClickDetectorListener {
    private final ClickDetector mClickDetector = new ClickDetector(this);

    public AnalogOnScreenControl(float pX, float pY, Camera pCamera, ITextureRegion pControlBaseTextureRegion, ITextureRegion pControlKnobTextureRegion, float pTimeBetweenUpdates, VertexBufferObjectManager pVertexBufferObjectManager, IAnalogOnScreenControlListener pAnalogOnScreenControlListener) {
        super(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, pVertexBufferObjectManager, pAnalogOnScreenControlListener);
        this.mClickDetector.setEnabled(false);
    }

    public AnalogOnScreenControl(float pX, float pY, Camera pCamera, ITextureRegion pControlBaseTextureRegion, ITextureRegion pControlKnobTextureRegion, float pTimeBetweenUpdates, long pOnControlClickMaximumMilliseconds, VertexBufferObjectManager pVertexBufferObjectManager, IAnalogOnScreenControlListener pAnalogOnScreenControlListener) {
        super(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, pVertexBufferObjectManager, pAnalogOnScreenControlListener);
        this.mClickDetector.setTriggerClickMaximumMilliseconds(pOnControlClickMaximumMilliseconds);
    }

    @Override
    public IAnalogOnScreenControlListener getOnScreenControlListener() {
        return (IAnalogOnScreenControlListener)super.getOnScreenControlListener();
    }

    public void setOnControlClickEnabled(boolean pOnControlClickEnabled) {
        this.mClickDetector.setEnabled(pOnControlClickEnabled);
    }

    public void setOnControlClickMaximumMilliseconds(long pOnControlClickMaximumMilliseconds) {
        this.mClickDetector.setTriggerClickMaximumMilliseconds(pOnControlClickMaximumMilliseconds);
    }

    @Override
    public void onClick(ClickDetector pClickDetector, int pPointerID, float pSceneX, float pSceneY) {
        this.getOnScreenControlListener().onControlClick(this);
    }

    @Override
    protected boolean onHandleControlBaseTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
        this.mClickDetector.onSceneTouchEvent(null, pSceneTouchEvent);
        return super.onHandleControlBaseTouched(pSceneTouchEvent, pTouchAreaLocalX, pTouchAreaLocalY);
    }

    @Override
    protected void onUpdateControlKnob(float pRelativeX, float pRelativeY) {
        if (pRelativeX * pRelativeX + pRelativeY * pRelativeY <= 0.25f) {
            super.onUpdateControlKnob(pRelativeX, pRelativeY);
        } else {
            float angleRad = MathUtils.atan2(pRelativeY, pRelativeX);
            super.onUpdateControlKnob((float)(Math.cos(angleRad) * 0.5), (float)(Math.sin(angleRad) * 0.5));
        }
    }

    public static interface IAnalogOnScreenControlListener
    extends BaseOnScreenControl.IOnScreenControlListener {
        public void onControlClick(AnalogOnScreenControl var1);
    }
}

