/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera.hud.controls;

import org.andengine.engine.camera.Camera;
import org.andengine.engine.camera.hud.HUD;
import org.andengine.engine.handler.timer.ITimerCallback;
import org.andengine.engine.handler.timer.TimerHandler;
import org.andengine.entity.scene.IOnSceneTouchListener;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.sprite.Sprite;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.util.math.MathUtils;

public abstract class BaseOnScreenControl
extends HUD
implements IOnSceneTouchListener {
    private static final int INVALID_POINTER_ID = -1;
    private final Sprite mControlBase;
    private final Sprite mControlKnob;
    private float mControlValueX;
    private float mControlValueY;
    private final IOnScreenControlListener mOnScreenControlListener;
    private int mActivePointerID = -1;

    public BaseOnScreenControl(float pX, float pY, Camera pCamera, ITextureRegion pControlBaseTextureRegion, ITextureRegion pControlKnobTextureRegion, float pTimeBetweenUpdates, VertexBufferObjectManager pVertexBufferObjectManager, IOnScreenControlListener pOnScreenControlListener) {
        this.setCamera(pCamera);
        this.mOnScreenControlListener = pOnScreenControlListener;
        this.mControlBase = new Sprite(pX, pY, pControlBaseTextureRegion, pVertexBufferObjectManager){

            @Override
            public boolean onAreaTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
                return BaseOnScreenControl.this.onHandleControlBaseTouched(pSceneTouchEvent, pTouchAreaLocalX, pTouchAreaLocalY);
            }
        };
        this.mControlKnob = new Sprite(0.0f, 0.0f, pControlKnobTextureRegion, pVertexBufferObjectManager);
        this.onHandleControlKnobReleased();
        this.setOnSceneTouchListener(this);
        this.registerTouchArea(this.mControlBase);
        this.registerUpdateHandler(new TimerHandler(pTimeBetweenUpdates, true, new ITimerCallback(){

            @Override
            public void onTimePassed(TimerHandler pTimerHandler) {
                BaseOnScreenControl.this.mOnScreenControlListener.onControlChange(BaseOnScreenControl.this, BaseOnScreenControl.this.mControlValueX, BaseOnScreenControl.this.mControlValueY);
            }
        }));
        this.attachChild(this.mControlBase);
        this.attachChild(this.mControlKnob);
        this.setTouchAreaBindingOnActionDownEnabled(true);
    }

    public Sprite getControlBase() {
        return this.mControlBase;
    }

    public Sprite getControlKnob() {
        return this.mControlKnob;
    }

    public IOnScreenControlListener getOnScreenControlListener() {
        return this.mOnScreenControlListener;
    }

    @Override
    public boolean onSceneTouchEvent(Scene pScene, TouchEvent pSceneTouchEvent) {
        int pointerID = pSceneTouchEvent.getPointerID();
        if (pointerID == this.mActivePointerID) {
            this.onHandleControlBaseLeft();
            switch (pSceneTouchEvent.getAction()) {
                case 1: 
                case 3: {
                    this.mActivePointerID = -1;
                }
            }
        }
        return false;
    }

    public void refreshControlKnobPosition() {
        this.onUpdateControlKnob(this.mControlValueX * 0.5f, this.mControlValueY * 0.5f);
    }

    protected void onHandleControlBaseLeft() {
        this.onUpdateControlKnob(0.0f, 0.0f);
    }

    protected void onHandleControlKnobReleased() {
        this.onUpdateControlKnob(0.0f, 0.0f);
    }

    protected boolean onHandleControlBaseTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
        int pointerID = pSceneTouchEvent.getPointerID();
        switch (pSceneTouchEvent.getAction()) {
            case 0: {
                if (this.mActivePointerID != -1) break;
                this.mActivePointerID = pointerID;
                this.updateControlKnob(pTouchAreaLocalX, pTouchAreaLocalY);
                return true;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerID != pointerID) break;
                this.mActivePointerID = -1;
                this.onHandleControlKnobReleased();
                return true;
            }
            default: {
                if (this.mActivePointerID != pointerID) break;
                this.updateControlKnob(pTouchAreaLocalX, pTouchAreaLocalY);
                return true;
            }
        }
        return true;
    }

    private void updateControlKnob(float pTouchAreaLocalX, float pTouchAreaLocalY) {
        Sprite controlBase = this.mControlBase;
        float relativeX = MathUtils.bringToBounds(0.0f, controlBase.getWidth(), pTouchAreaLocalX) / controlBase.getWidth() - 0.5f;
        float relativeY = MathUtils.bringToBounds(0.0f, controlBase.getHeight(), pTouchAreaLocalY) / controlBase.getHeight() - 0.5f;
        this.onUpdateControlKnob(relativeX, relativeY);
    }

    protected void onUpdateControlKnob(float pRelativeX, float pRelativeY) {
        Sprite controlBase = this.mControlBase;
        Sprite controlKnob = this.mControlKnob;
        this.mControlValueX = 2.0f * pRelativeX;
        this.mControlValueY = 2.0f * pRelativeY;
        float[] controlBaseSceneCenterCoordinates = controlBase.getSceneCenterCoordinates();
        float x = controlBaseSceneCenterCoordinates[0] - controlKnob.getWidth() * 0.5f + pRelativeX * controlBase.getWidthScaled();
        float y = controlBaseSceneCenterCoordinates[1] - controlKnob.getHeight() * 0.5f + pRelativeY * controlBase.getHeightScaled();
        controlKnob.setPosition(x, y);
    }

    public static interface IOnScreenControlListener {
        public void onControlChange(BaseOnScreenControl var1, float var2, float var3);
    }
}

