/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.camera.hud.controls;

import org.andengine.engine.camera.Camera;
import org.andengine.engine.camera.hud.controls.BaseOnScreenControl;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.util.math.MathUtils;

public class DigitalOnScreenControl
extends BaseOnScreenControl {
    private static final float EXTENT_SIDE = 0.5f;
    private static final float EXTENT_DIAGONAL = 0.354f;
    private static final float ANGLE_DELTA = 22.5f;
    private boolean mAllowDiagonal;

    public DigitalOnScreenControl(float pX, float pY, Camera pCamera, ITextureRegion pControlBaseTextureRegion, ITextureRegion pControlKnobTextureRegion, float pTimeBetweenUpdates, VertexBufferObjectManager pVertexBufferObjectManager, BaseOnScreenControl.IOnScreenControlListener pOnScreenControlListener) {
        this(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, false, pVertexBufferObjectManager, pOnScreenControlListener);
    }

    public DigitalOnScreenControl(float pX, float pY, Camera pCamera, ITextureRegion pControlBaseTextureRegion, ITextureRegion pControlKnobTextureRegion, float pTimeBetweenUpdates, boolean pAllowDiagonal, VertexBufferObjectManager pVertexBufferObjectManager, BaseOnScreenControl.IOnScreenControlListener pOnScreenControlListener) {
        super(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, pVertexBufferObjectManager, pOnScreenControlListener);
        this.mAllowDiagonal = pAllowDiagonal;
    }

    public boolean isAllowDiagonal() {
        return this.mAllowDiagonal;
    }

    public void setAllowDiagonal(boolean pAllowDiagonal) {
        this.mAllowDiagonal = pAllowDiagonal;
    }

    @Override
    protected void onUpdateControlKnob(float pRelativeX, float pRelativeY) {
        if (pRelativeX == 0.0f && pRelativeY == 0.0f) {
            super.onUpdateControlKnob(0.0f, 0.0f);
            return;
        }
        if (this.mAllowDiagonal) {
            float angle = MathUtils.radToDeg(MathUtils.atan2(pRelativeY, pRelativeX)) + 180.0f;
            if (DigitalOnScreenControl.testDiagonalAngle(0.0f, angle) || DigitalOnScreenControl.testDiagonalAngle(360.0f, angle)) {
                super.onUpdateControlKnob(-0.5f, 0.0f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(45.0f, angle)) {
                super.onUpdateControlKnob(-0.354f, -0.354f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(90.0f, angle)) {
                super.onUpdateControlKnob(0.0f, -0.5f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(135.0f, angle)) {
                super.onUpdateControlKnob(0.354f, -0.354f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(180.0f, angle)) {
                super.onUpdateControlKnob(0.5f, 0.0f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(225.0f, angle)) {
                super.onUpdateControlKnob(0.354f, 0.354f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(270.0f, angle)) {
                super.onUpdateControlKnob(0.0f, 0.5f);
            } else if (DigitalOnScreenControl.testDiagonalAngle(315.0f, angle)) {
                super.onUpdateControlKnob(-0.354f, 0.354f);
            } else {
                super.onUpdateControlKnob(0.0f, 0.0f);
            }
        } else if (Math.abs(pRelativeX) > Math.abs(pRelativeY)) {
            if (pRelativeX > 0.0f) {
                super.onUpdateControlKnob(0.5f, 0.0f);
            } else if (pRelativeX < 0.0f) {
                super.onUpdateControlKnob(-0.5f, 0.0f);
            } else if (pRelativeX == 0.0f) {
                super.onUpdateControlKnob(0.0f, 0.0f);
            }
        } else if (pRelativeY > 0.0f) {
            super.onUpdateControlKnob(0.0f, 0.5f);
        } else if (pRelativeY < 0.0f) {
            super.onUpdateControlKnob(0.0f, -0.5f);
        } else if (pRelativeY == 0.0f) {
            super.onUpdateControlKnob(0.0f, 0.0f);
        }
    }

    private static boolean testDiagonalAngle(float pTestAngle, float pActualAngle) {
        return pActualAngle > pTestAngle - 22.5f && pActualAngle < pTestAngle + 22.5f;
    }
}

