/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.handler.collision;

import java.util.ArrayList;
import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.engine.handler.collision.ICollisionCallback;
import org.andengine.entity.shape.IShape;
import org.andengine.util.adt.list.ListUtils;

public class CollisionHandler
implements IUpdateHandler {
    private final ICollisionCallback mCollisionCallback;
    private final IShape mCheckShape;
    private final ArrayList<? extends IShape> mTargetStaticEntities;

    public CollisionHandler(ICollisionCallback pCollisionCallback, IShape pCheckShape, IShape pTargetShape) throws IllegalArgumentException {
        this(pCollisionCallback, pCheckShape, ListUtils.toList(pTargetShape));
    }

    public CollisionHandler(ICollisionCallback pCollisionCallback, IShape pCheckShape, ArrayList<? extends IShape> pTargetStaticEntities) throws IllegalArgumentException {
        if (pCollisionCallback == null) {
            throw new IllegalArgumentException("pCollisionCallback must not be null!");
        }
        if (pCheckShape == null) {
            throw new IllegalArgumentException("pCheckShape must not be null!");
        }
        if (pTargetStaticEntities == null) {
            throw new IllegalArgumentException("pTargetStaticEntities must not be null!");
        }
        this.mCollisionCallback = pCollisionCallback;
        this.mCheckShape = pCheckShape;
        this.mTargetStaticEntities = pTargetStaticEntities;
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        IShape checkShape = this.mCheckShape;
        ArrayList<? extends IShape> staticEntities = this.mTargetStaticEntities;
        int staticEntityCount = staticEntities.size();
        for (int i = 0; i < staticEntityCount; ++i) {
            boolean proceed;
            if (!checkShape.collidesWith(staticEntities.get(i)) || (proceed = this.mCollisionCallback.onCollision(checkShape, staticEntities.get(i)))) continue;
            return;
        }
    }

    @Override
    public void reset() {
    }
}

