/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.options.resolutionpolicy;

import android.view.View;
import org.andengine.engine.options.resolutionpolicy.BaseResolutionPolicy;
import org.andengine.opengl.view.RenderSurfaceView;

public class RatioResolutionPolicy
extends BaseResolutionPolicy {
    private final float mRatio;

    public RatioResolutionPolicy(float pRatio) {
        this.mRatio = pRatio;
    }

    public RatioResolutionPolicy(float pWidthRatio, float pHeightRatio) {
        this.mRatio = pWidthRatio / pHeightRatio;
    }

    @Override
    public void onMeasure(RenderSurfaceView pRenderSurfaceView, int pWidthMeasureSpec, int pHeightMeasureSpec) {
        int measuredHeight;
        int measuredWidth;
        BaseResolutionPolicy.throwOnNotMeasureSpecEXACTLY(pWidthMeasureSpec, pHeightMeasureSpec);
        int specWidth = View.MeasureSpec.getSize((int)pWidthMeasureSpec);
        int specHeight = View.MeasureSpec.getSize((int)pHeightMeasureSpec);
        float desiredRatio = this.mRatio;
        float realRatio = (float)specWidth / (float)specHeight;
        if (realRatio < desiredRatio) {
            measuredWidth = specWidth;
            measuredHeight = Math.round((float)measuredWidth / desiredRatio);
        } else {
            measuredHeight = specHeight;
            measuredWidth = Math.round((float)measuredHeight * desiredRatio);
        }
        pRenderSurfaceView.setMeasuredDimensionProxy(measuredWidth, measuredHeight);
    }
}

