/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.splitscreen;

import android.opengl.GLES20;
import org.andengine.engine.Engine;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.options.EngineOptions;
import org.andengine.entity.scene.Scene;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.util.GLState;

public class DoubleSceneSplitScreenEngine
extends Engine {
    private Scene mSecondScene;
    private final Camera mSecondCamera;

    public DoubleSceneSplitScreenEngine(EngineOptions pEngineOptions, Camera pSecondCamera) {
        super(pEngineOptions);
        this.mSecondCamera = pSecondCamera;
    }

    @Override
    @Deprecated
    public Camera getCamera() {
        return this.mCamera;
    }

    public Camera getFirstCamera() {
        return this.mCamera;
    }

    public Camera getSecondCamera() {
        return this.mSecondCamera;
    }

    @Override
    @Deprecated
    public Scene getScene() {
        return super.getScene();
    }

    public Scene getFirstScene() {
        return super.getScene();
    }

    public Scene getSecondScene() {
        return this.mSecondScene;
    }

    @Override
    @Deprecated
    public void setScene(Scene pScene) {
        this.setFirstScene(pScene);
    }

    public void setFirstScene(Scene pScene) {
        super.setScene(pScene);
    }

    public void setSecondScene(Scene pScene) {
        this.mSecondScene = pScene;
    }

    @Override
    protected void onDrawScene(GLState pGLState, Camera pFirstCamera) {
        Camera secondCamera = this.getSecondCamera();
        int surfaceWidth = this.mSurfaceWidth;
        int surfaceWidthHalf = surfaceWidth >> 1;
        int surfaceHeight = this.mSurfaceHeight;
        pGLState.enableScissorTest();
        if (this.mScene != null) {
            GLES20.glScissor((int)0, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            GLES20.glViewport((int)0, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            this.mScene.onDraw(pGLState, pFirstCamera);
            pFirstCamera.onDrawHUD(pGLState);
        }
        if (this.mSecondScene != null) {
            GLES20.glScissor((int)surfaceWidthHalf, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            GLES20.glViewport((int)surfaceWidthHalf, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            this.mSecondScene.onDraw(pGLState, secondCamera);
            secondCamera.onDrawHUD(pGLState);
        }
        pGLState.disableScissorTest();
    }

    @Override
    protected Camera getCameraFromSurfaceTouchEvent(TouchEvent pTouchEvent) {
        if (pTouchEvent.getX() <= (float)(this.mSurfaceWidth >> 1)) {
            return this.getFirstCamera();
        }
        return this.getSecondCamera();
    }

    @Override
    protected Scene getSceneFromSurfaceTouchEvent(TouchEvent pTouchEvent) {
        if (pTouchEvent.getX() <= (float)(this.mSurfaceWidth >> 1)) {
            return this.getFirstScene();
        }
        return this.getSecondScene();
    }

    @Override
    protected void onUpdateScene(float pSecondsElapsed) {
        super.onUpdateScene(pSecondsElapsed);
        if (this.mSecondScene != null) {
            this.mSecondScene.onUpdate(pSecondsElapsed);
        }
    }

    @Override
    protected void convertSurfaceToSceneTouchEvent(Camera pCamera, TouchEvent pSurfaceTouchEvent) {
        int surfaceWidthHalf = this.mSurfaceWidth >> 1;
        if (pCamera == this.getFirstCamera()) {
            pCamera.convertSurfaceToSceneTouchEvent(pSurfaceTouchEvent, surfaceWidthHalf, this.mSurfaceHeight);
        } else {
            pSurfaceTouchEvent.offset(-surfaceWidthHalf, 0.0f);
            pCamera.convertSurfaceToSceneTouchEvent(pSurfaceTouchEvent, surfaceWidthHalf, this.mSurfaceHeight);
        }
    }

    @Override
    protected void onUpdateUpdateHandlers(float pSecondsElapsed) {
        super.onUpdateUpdateHandlers(pSecondsElapsed);
        this.getSecondCamera().onUpdate(pSecondsElapsed);
    }

    @Override
    protected void onUpdateCameraSurface() {
        int surfaceWidth = this.mSurfaceWidth;
        int surfaceWidthHalf = surfaceWidth >> 1;
        this.getFirstCamera().setSurfaceSize(0, 0, surfaceWidthHalf, this.mSurfaceHeight);
        this.getSecondCamera().setSurfaceSize(surfaceWidthHalf, 0, surfaceWidthHalf, this.mSurfaceHeight);
    }
}

