/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.engine.splitscreen;

import android.opengl.GLES20;
import org.andengine.engine.Engine;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.options.EngineOptions;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.util.GLState;

public class SingleSceneSplitScreenEngine
extends Engine {
    private final Camera mSecondCamera;

    public SingleSceneSplitScreenEngine(EngineOptions pEngineOptions, Camera pSecondCamera) {
        super(pEngineOptions);
        this.mSecondCamera = pSecondCamera;
    }

    @Override
    @Deprecated
    public Camera getCamera() {
        return this.mCamera;
    }

    public Camera getFirstCamera() {
        return this.mCamera;
    }

    public Camera getSecondCamera() {
        return this.mSecondCamera;
    }

    @Override
    protected void onDrawScene(GLState pGLState, Camera pFirstCamera) {
        if (this.mScene != null) {
            Camera secondCamera = this.getSecondCamera();
            int surfaceWidth = this.mSurfaceWidth;
            int surfaceWidthHalf = surfaceWidth >> 1;
            int surfaceHeight = this.mSurfaceHeight;
            pGLState.enableScissorTest();
            GLES20.glScissor((int)0, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            GLES20.glViewport((int)0, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            this.mScene.onDraw(pGLState, pFirstCamera);
            pFirstCamera.onDrawHUD(pGLState);
            GLES20.glScissor((int)surfaceWidthHalf, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            GLES20.glViewport((int)surfaceWidthHalf, (int)0, (int)surfaceWidthHalf, (int)surfaceHeight);
            this.mScene.onDraw(pGLState, secondCamera);
            secondCamera.onDrawHUD(pGLState);
            pGLState.disableScissorTest();
        }
    }

    @Override
    protected Camera getCameraFromSurfaceTouchEvent(TouchEvent pTouchEvent) {
        if (pTouchEvent.getX() <= (float)(this.mSurfaceWidth >> 1)) {
            return this.getFirstCamera();
        }
        return this.getSecondCamera();
    }

    @Override
    protected void convertSurfaceToSceneTouchEvent(Camera pCamera, TouchEvent pSurfaceTouchEvent) {
        int surfaceWidthHalf = this.mSurfaceWidth >> 1;
        if (pCamera == this.getFirstCamera()) {
            pCamera.convertSurfaceToSceneTouchEvent(pSurfaceTouchEvent, surfaceWidthHalf, this.mSurfaceHeight);
        } else {
            pSurfaceTouchEvent.offset(-surfaceWidthHalf, 0.0f);
            pCamera.convertSurfaceToSceneTouchEvent(pSurfaceTouchEvent, surfaceWidthHalf, this.mSurfaceHeight);
        }
    }

    @Override
    protected void onUpdateUpdateHandlers(float pSecondsElapsed) {
        super.onUpdateUpdateHandlers(pSecondsElapsed);
        this.getSecondCamera().onUpdate(pSecondsElapsed);
    }

    @Override
    protected void onUpdateCameraSurface() {
        int surfaceWidth = this.mSurfaceWidth;
        int surfaceWidthHalf = surfaceWidth >> 1;
        this.getFirstCamera().setSurfaceSize(0, 0, surfaceWidthHalf, this.mSurfaceHeight);
        this.getSecondCamera().setSurfaceSize(surfaceWidthHalf, 0, surfaceWidthHalf, this.mSurfaceHeight);
    }
}

