/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity;

import java.util.ArrayList;
import java.util.List;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.engine.handler.UpdateHandlerList;
import org.andengine.entity.IEntity;
import org.andengine.entity.IEntityComparator;
import org.andengine.entity.IEntityMatcher;
import org.andengine.entity.IEntityParameterCallable;
import org.andengine.entity.ZIndexSorter;
import org.andengine.entity.modifier.EntityModifierList;
import org.andengine.entity.modifier.IEntityModifier;
import org.andengine.opengl.util.GLState;
import org.andengine.util.IDisposable;
import org.andengine.util.adt.list.SmartList;
import org.andengine.util.adt.transformation.Transformation;
import org.andengine.util.call.ParameterCallable;
import org.andengine.util.color.Color;

public class Entity
implements IEntity {
    private static final int CHILDREN_CAPACITY_DEFAULT = 4;
    private static final int ENTITYMODIFIERS_CAPACITY_DEFAULT = 4;
    private static final int UPDATEHANDLERS_CAPACITY_DEFAULT = 4;
    private static final float[] VERTICES_SCENE_TO_LOCAL_TMP = new float[2];
    private static final float[] VERTICES_LOCAL_TO_SCENE_TMP = new float[2];
    private static final ParameterCallable<IEntity> PARAMETERCALLABLE_DETACHCHILD = new ParameterCallable<IEntity>(){

        @Override
        public void call(IEntity pEntity) {
            pEntity.setParent(null);
            pEntity.onDetached();
        }
    };
    protected boolean mDisposed;
    protected boolean mVisible = true;
    protected boolean mCullingEnabled;
    protected boolean mIgnoreUpdate;
    protected boolean mChildrenVisible = true;
    protected boolean mChildrenIgnoreUpdate;
    protected boolean mChildrenSortPending;
    protected int mTag = Integer.MIN_VALUE;
    protected int mZIndex = 0;
    private IEntity mParent;
    protected SmartList<IEntity> mChildren;
    private EntityModifierList mEntityModifiers;
    private UpdateHandlerList mUpdateHandlers;
    protected Color mColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected float mX;
    protected float mY;
    protected float mRotation = 0.0f;
    protected float mRotationCenterX = 0.0f;
    protected float mRotationCenterY = 0.0f;
    protected float mScaleX = 1.0f;
    protected float mScaleY = 1.0f;
    protected float mScaleCenterX = 0.0f;
    protected float mScaleCenterY = 0.0f;
    protected float mSkewX = 0.0f;
    protected float mSkewY = 0.0f;
    protected float mSkewCenterX = 0.0f;
    protected float mSkewCenterY = 0.0f;
    private boolean mLocalToParentTransformationDirty = true;
    private boolean mParentToLocalTransformationDirty = true;
    private Transformation mLocalToParentTransformation;
    private Transformation mParentToLocalTransformation;
    private Transformation mLocalToSceneTransformation;
    private Transformation mSceneToLocalTransformation;
    private Object mUserData;

    public Entity() {
        this(0.0f, 0.0f);
    }

    public Entity(float pX, float pY) {
        this.mX = pX;
        this.mY = pY;
    }

    protected void onUpdateColor() {
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    @Override
    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    public void setVisible(boolean pVisible) {
        this.mVisible = pVisible;
    }

    @Override
    public boolean isCullingEnabled() {
        return this.mCullingEnabled;
    }

    @Override
    public void setCullingEnabled(boolean pCullingEnabled) {
        this.mCullingEnabled = pCullingEnabled;
    }

    @Override
    public boolean isCulled(Camera pCamera) {
        return false;
    }

    @Override
    public boolean isChildrenVisible() {
        return this.mChildrenVisible;
    }

    @Override
    public void setChildrenVisible(boolean pChildrenVisible) {
        this.mChildrenVisible = pChildrenVisible;
    }

    @Override
    public boolean isIgnoreUpdate() {
        return this.mIgnoreUpdate;
    }

    @Override
    public void setIgnoreUpdate(boolean pIgnoreUpdate) {
        this.mIgnoreUpdate = pIgnoreUpdate;
    }

    @Override
    public boolean isChildrenIgnoreUpdate() {
        return this.mChildrenIgnoreUpdate;
    }

    @Override
    public void setChildrenIgnoreUpdate(boolean pChildrenIgnoreUpdate) {
        this.mChildrenIgnoreUpdate = pChildrenIgnoreUpdate;
    }

    @Override
    public boolean hasParent() {
        return this.mParent != null;
    }

    @Override
    public IEntity getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IEntity pEntity) {
        this.mParent = pEntity;
    }

    @Override
    public int getTag() {
        return this.mTag;
    }

    @Override
    public void setTag(int pTag) {
        this.mTag = pTag;
    }

    @Override
    public int getZIndex() {
        return this.mZIndex;
    }

    @Override
    public void setZIndex(int pZIndex) {
        this.mZIndex = pZIndex;
    }

    @Override
    public float getX() {
        return this.mX;
    }

    @Override
    public float getY() {
        return this.mY;
    }

    @Override
    public void setX(float pX) {
        this.mX = pX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setY(float pY) {
        this.mY = pY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setPosition(IEntity pOtherEntity) {
        this.setPosition(pOtherEntity.getX(), pOtherEntity.getY());
    }

    @Override
    public void setPosition(float pX, float pY) {
        this.mX = pX;
        this.mY = pY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public float getRotation() {
        return this.mRotation;
    }

    @Override
    public boolean isRotated() {
        return this.mRotation != 0.0f;
    }

    @Override
    public void setRotation(float pRotation) {
        this.mRotation = pRotation;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public float getRotationCenterX() {
        return this.mRotationCenterX;
    }

    @Override
    public float getRotationCenterY() {
        return this.mRotationCenterY;
    }

    @Override
    public void setRotationCenterX(float pRotationCenterX) {
        this.mRotationCenterX = pRotationCenterX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setRotationCenterY(float pRotationCenterY) {
        this.mRotationCenterY = pRotationCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setRotationCenter(float pRotationCenterX, float pRotationCenterY) {
        this.mRotationCenterX = pRotationCenterX;
        this.mRotationCenterY = pRotationCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public boolean isScaled() {
        return this.mScaleX != 1.0f || this.mScaleY != 1.0f;
    }

    @Override
    public float getScaleX() {
        return this.mScaleX;
    }

    @Override
    public float getScaleY() {
        return this.mScaleY;
    }

    @Override
    public void setScaleX(float pScaleX) {
        this.mScaleX = pScaleX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setScaleY(float pScaleY) {
        this.mScaleY = pScaleY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setScale(float pScale) {
        this.mScaleX = pScale;
        this.mScaleY = pScale;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setScale(float pScaleX, float pScaleY) {
        this.mScaleX = pScaleX;
        this.mScaleY = pScaleY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public float getScaleCenterX() {
        return this.mScaleCenterX;
    }

    @Override
    public float getScaleCenterY() {
        return this.mScaleCenterY;
    }

    @Override
    public void setScaleCenterX(float pScaleCenterX) {
        this.mScaleCenterX = pScaleCenterX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setScaleCenterY(float pScaleCenterY) {
        this.mScaleCenterY = pScaleCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setScaleCenter(float pScaleCenterX, float pScaleCenterY) {
        this.mScaleCenterX = pScaleCenterX;
        this.mScaleCenterY = pScaleCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public boolean isSkewed() {
        return this.mSkewX != 0.0f || this.mSkewY != 0.0f;
    }

    @Override
    public float getSkewX() {
        return this.mSkewX;
    }

    @Override
    public float getSkewY() {
        return this.mSkewY;
    }

    @Override
    public void setSkewX(float pSkewX) {
        this.mSkewX = pSkewX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setSkewY(float pSkewY) {
        this.mSkewY = pSkewY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setSkew(float pSkew) {
        this.mSkewX = pSkew;
        this.mSkewY = pSkew;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setSkew(float pSkewX, float pSkewY) {
        this.mSkewX = pSkewX;
        this.mSkewY = pSkewY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public float getSkewCenterX() {
        return this.mSkewCenterX;
    }

    @Override
    public float getSkewCenterY() {
        return this.mSkewCenterY;
    }

    @Override
    public void setSkewCenterX(float pSkewCenterX) {
        this.mSkewCenterX = pSkewCenterX;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setSkewCenterY(float pSkewCenterY) {
        this.mSkewCenterY = pSkewCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public void setSkewCenter(float pSkewCenterX, float pSkewCenterY) {
        this.mSkewCenterX = pSkewCenterX;
        this.mSkewCenterY = pSkewCenterY;
        this.mLocalToParentTransformationDirty = true;
        this.mParentToLocalTransformationDirty = true;
    }

    @Override
    public boolean isRotatedOrScaledOrSkewed() {
        return this.mRotation != 0.0f || this.mScaleX != 1.0f || this.mScaleY != 1.0f || this.mSkewX != 0.0f || this.mSkewY != 0.0f;
    }

    @Override
    public float getRed() {
        return this.mColor.getRed();
    }

    @Override
    public float getGreen() {
        return this.mColor.getGreen();
    }

    @Override
    public float getBlue() {
        return this.mColor.getBlue();
    }

    @Override
    public float getAlpha() {
        return this.mColor.getAlpha();
    }

    @Override
    public Color getColor() {
        return this.mColor;
    }

    @Override
    public void setColor(Color pColor) {
        this.mColor.set(pColor);
        this.onUpdateColor();
    }

    @Override
    public void setRed(float pRed) {
        if (this.mColor.setRedChecking(pRed)) {
            this.onUpdateColor();
        }
    }

    @Override
    public void setGreen(float pGreen) {
        if (this.mColor.setGreenChecking(pGreen)) {
            this.onUpdateColor();
        }
    }

    @Override
    public void setBlue(float pBlue) {
        if (this.mColor.setBlueChecking(pBlue)) {
            this.onUpdateColor();
        }
    }

    @Override
    public void setAlpha(float pAlpha) {
        if (this.mColor.setAlphaChecking(pAlpha)) {
            this.onUpdateColor();
        }
    }

    @Override
    public void setColor(float pRed, float pGreen, float pBlue) {
        if (this.mColor.setChecking(pRed, pGreen, pBlue)) {
            this.onUpdateColor();
        }
    }

    @Override
    public void setColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        if (this.mColor.setChecking(pRed, pGreen, pBlue, pAlpha)) {
            this.onUpdateColor();
        }
    }

    @Override
    public int getChildCount() {
        if (this.mChildren == null) {
            return 0;
        }
        return this.mChildren.size();
    }

    @Override
    public IEntity getChildByTag(int pTag) {
        if (this.mChildren == null) {
            return null;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            IEntity child = (IEntity)this.mChildren.get(i);
            if (child.getTag() != pTag) continue;
            return child;
        }
        return null;
    }

    @Override
    public IEntity getChildByIndex(int pIndex) {
        if (this.mChildren == null) {
            return null;
        }
        return (IEntity)this.mChildren.get(pIndex);
    }

    @Override
    public IEntity getChildByMatcher(IEntityMatcher pEntityMatcher) {
        if (this.mChildren == null) {
            return null;
        }
        return this.mChildren.get(pEntityMatcher);
    }

    @Override
    public IEntity getFirstChild() {
        if (this.mChildren == null) {
            return null;
        }
        return (IEntity)this.mChildren.get(0);
    }

    @Override
    public IEntity getLastChild() {
        if (this.mChildren == null) {
            return null;
        }
        return (IEntity)this.mChildren.get(this.mChildren.size() - 1);
    }

    @Override
    public ArrayList<IEntity> query(IEntityMatcher pEntityMatcher) {
        return this.query(pEntityMatcher, new ArrayList());
    }

    @Override
    public IEntity queryFirst(IEntityMatcher pEntityMatcher) {
        return this.queryFirstForSubclass(pEntityMatcher);
    }

    @Override
    public <S extends IEntity> S queryFirstForSubclass(IEntityMatcher pEntityMatcher) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IEntity child = (IEntity)this.mChildren.get(i);
            if (pEntityMatcher.matches(child)) {
                return (S)child;
            }
            Object childQueryFirst = child.queryFirstForSubclass(pEntityMatcher);
            if (childQueryFirst == null) continue;
            return childQueryFirst;
        }
        return null;
    }

    @Override
    public <L extends List<IEntity>> L query(IEntityMatcher pEntityMatcher, L pResult) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IEntity child = (IEntity)this.mChildren.get(i);
            if (pEntityMatcher.matches(child)) {
                pResult.add((IEntity)child);
            }
            child.query(pEntityMatcher, pResult);
        }
        return pResult;
    }

    @Override
    public <S extends IEntity> ArrayList<S> queryForSubclass(IEntityMatcher pEntityMatcher) throws ClassCastException {
        return this.queryForSubclass(pEntityMatcher, new ArrayList());
    }

    @Override
    public <L extends List<S>, S extends IEntity> L queryForSubclass(IEntityMatcher pEntityMatcher, L pResult) throws ClassCastException {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IEntity child = (IEntity)this.mChildren.get(i);
            if (pEntityMatcher.matches(child)) {
                pResult.add((IEntity)child);
            }
            child.queryForSubclass(pEntityMatcher, pResult);
        }
        return pResult;
    }

    @Override
    public boolean detachSelf() {
        IEntity parent = this.mParent;
        if (parent != null) {
            return parent.detachChild(this);
        }
        return false;
    }

    @Override
    public void detachChildren() {
        if (this.mChildren == null) {
            return;
        }
        this.mChildren.clear(PARAMETERCALLABLE_DETACHCHILD);
    }

    @Override
    public void attachChild(IEntity pEntity) throws IllegalStateException {
        this.assertEntityHasNoParent(pEntity);
        if (this.mChildren == null) {
            this.allocateChildren();
        }
        this.mChildren.add(pEntity);
        pEntity.setParent(this);
        pEntity.onAttached();
    }

    @Override
    public void sortChildren() {
        this.sortChildren(true);
    }

    @Override
    public void sortChildren(boolean pImmediate) {
        if (this.mChildren == null) {
            return;
        }
        if (pImmediate) {
            ZIndexSorter.getInstance().sort(this.mChildren);
        } else {
            this.mChildrenSortPending = true;
        }
    }

    @Override
    public void sortChildren(IEntityComparator pEntityComparator) {
        if (this.mChildren == null) {
            return;
        }
        ZIndexSorter.getInstance().sort(this.mChildren, pEntityComparator);
    }

    @Override
    public boolean detachChild(IEntity pEntity) {
        if (this.mChildren == null) {
            return false;
        }
        return this.mChildren.remove(pEntity, PARAMETERCALLABLE_DETACHCHILD);
    }

    @Override
    public IEntity detachChild(int pTag) {
        if (this.mChildren == null) {
            return null;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (((IEntity)this.mChildren.get(i)).getTag() != pTag) continue;
            IEntity removed = (IEntity)this.mChildren.remove(i);
            PARAMETERCALLABLE_DETACHCHILD.call(removed);
            return removed;
        }
        return null;
    }

    @Override
    public IEntity detachChild(IEntityMatcher pEntityMatcher) {
        if (this.mChildren == null) {
            return null;
        }
        return this.mChildren.remove(pEntityMatcher, PARAMETERCALLABLE_DETACHCHILD);
    }

    @Override
    public boolean detachChildren(IEntityMatcher pEntityMatcher) {
        if (this.mChildren == null) {
            return false;
        }
        return this.mChildren.removeAll(pEntityMatcher, PARAMETERCALLABLE_DETACHCHILD);
    }

    @Override
    public void callOnChildren(IEntityParameterCallable pEntityParameterCallable) {
        if (this.mChildren == null) {
            return;
        }
        this.mChildren.call(pEntityParameterCallable);
    }

    @Override
    public void callOnChildren(IEntityParameterCallable pEntityParameterCallable, IEntityMatcher pEntityMatcher) {
        if (this.mChildren == null) {
            return;
        }
        this.mChildren.call(pEntityMatcher, pEntityParameterCallable);
    }

    @Override
    public void registerUpdateHandler(IUpdateHandler pUpdateHandler) {
        if (this.mUpdateHandlers == null) {
            this.allocateUpdateHandlers();
        }
        this.mUpdateHandlers.add(pUpdateHandler);
    }

    @Override
    public boolean unregisterUpdateHandler(IUpdateHandler pUpdateHandler) {
        if (this.mUpdateHandlers == null) {
            return false;
        }
        return this.mUpdateHandlers.remove(pUpdateHandler);
    }

    @Override
    public boolean unregisterUpdateHandlers(IUpdateHandler.IUpdateHandlerMatcher pUpdateHandlerMatcher) {
        if (this.mUpdateHandlers == null) {
            return false;
        }
        return this.mUpdateHandlers.removeAll(pUpdateHandlerMatcher);
    }

    @Override
    public int getUpdateHandlerCount() {
        if (this.mUpdateHandlers == null) {
            return 0;
        }
        return this.mUpdateHandlers.size();
    }

    @Override
    public void clearUpdateHandlers() {
        if (this.mUpdateHandlers == null) {
            return;
        }
        this.mUpdateHandlers.clear();
    }

    @Override
    public void registerEntityModifier(IEntityModifier pEntityModifier) {
        if (this.mEntityModifiers == null) {
            this.allocateEntityModifiers();
        }
        this.mEntityModifiers.add(pEntityModifier);
    }

    @Override
    public boolean unregisterEntityModifier(IEntityModifier pEntityModifier) {
        if (this.mEntityModifiers == null) {
            return false;
        }
        return this.mEntityModifiers.remove(pEntityModifier);
    }

    @Override
    public boolean unregisterEntityModifiers(IEntityModifier.IEntityModifierMatcher pEntityModifierMatcher) {
        if (this.mEntityModifiers == null) {
            return false;
        }
        return this.mEntityModifiers.removeAll(pEntityModifierMatcher);
    }

    @Override
    public int getEntityModifierCount() {
        if (this.mEntityModifiers == null) {
            return 0;
        }
        return this.mEntityModifiers.size();
    }

    @Override
    public void clearEntityModifiers() {
        if (this.mEntityModifiers == null) {
            return;
        }
        this.mEntityModifiers.clear();
    }

    @Override
    public float[] getSceneCenterCoordinates() {
        return this.convertLocalToSceneCoordinates(0.0f, 0.0f);
    }

    @Override
    public float[] getSceneCenterCoordinates(float[] pReuse) {
        return this.convertLocalToSceneCoordinates(0.0f, 0.0f, pReuse);
    }

    @Override
    public Transformation getLocalToParentTransformation() {
        if (this.mLocalToParentTransformation == null) {
            this.mLocalToParentTransformation = new Transformation();
        }
        Transformation localToParentTransformation = this.mLocalToParentTransformation;
        if (this.mLocalToParentTransformationDirty) {
            float rotation;
            localToParentTransformation.setToIdentity();
            float scaleX = this.mScaleX;
            float scaleY = this.mScaleY;
            if (scaleX != 1.0f || scaleY != 1.0f) {
                float scaleCenterX = this.mScaleCenterX;
                float scaleCenterY = this.mScaleCenterY;
                localToParentTransformation.postTranslate(-scaleCenterX, -scaleCenterY);
                localToParentTransformation.postScale(scaleX, scaleY);
                localToParentTransformation.postTranslate(scaleCenterX, scaleCenterY);
            }
            float skewX = this.mSkewX;
            float skewY = this.mSkewY;
            if (skewX != 0.0f || skewY != 0.0f) {
                float skewCenterX = this.mSkewCenterX;
                float skewCenterY = this.mSkewCenterY;
                localToParentTransformation.postTranslate(-skewCenterX, -skewCenterY);
                localToParentTransformation.postSkew(skewX, skewY);
                localToParentTransformation.postTranslate(skewCenterX, skewCenterY);
            }
            if ((rotation = this.mRotation) != 0.0f) {
                float rotationCenterX = this.mRotationCenterX;
                float rotationCenterY = this.mRotationCenterY;
                localToParentTransformation.postTranslate(-rotationCenterX, -rotationCenterY);
                localToParentTransformation.postRotate(rotation);
                localToParentTransformation.postTranslate(rotationCenterX, rotationCenterY);
            }
            localToParentTransformation.postTranslate(this.mX, this.mY);
            this.mLocalToParentTransformationDirty = false;
        }
        return localToParentTransformation;
    }

    @Override
    public Transformation getParentToLocalTransformation() {
        if (this.mParentToLocalTransformation == null) {
            this.mParentToLocalTransformation = new Transformation();
        }
        Transformation parentToLocalTransformation = this.mParentToLocalTransformation;
        if (this.mParentToLocalTransformationDirty) {
            parentToLocalTransformation.setToIdentity();
            parentToLocalTransformation.postTranslate(-this.mX, -this.mY);
            float rotation = this.mRotation;
            if (rotation != 0.0f) {
                float rotationCenterX = this.mRotationCenterX;
                float rotationCenterY = this.mRotationCenterY;
                parentToLocalTransformation.postTranslate(-rotationCenterX, -rotationCenterY);
                parentToLocalTransformation.postRotate(-rotation);
                parentToLocalTransformation.postTranslate(rotationCenterX, rotationCenterY);
            }
            float skewX = this.mSkewX;
            float skewY = this.mSkewY;
            if (skewX != 0.0f || skewY != 0.0f) {
                float skewCenterX = this.mSkewCenterX;
                float skewCenterY = this.mSkewCenterY;
                parentToLocalTransformation.postTranslate(-skewCenterX, -skewCenterY);
                parentToLocalTransformation.postSkew(-skewX, -skewY);
                parentToLocalTransformation.postTranslate(skewCenterX, skewCenterY);
            }
            float scaleX = this.mScaleX;
            float scaleY = this.mScaleY;
            if (scaleX != 1.0f || scaleY != 1.0f) {
                float scaleCenterX = this.mScaleCenterX;
                float scaleCenterY = this.mScaleCenterY;
                parentToLocalTransformation.postTranslate(-scaleCenterX, -scaleCenterY);
                parentToLocalTransformation.postScale(1.0f / scaleX, 1.0f / scaleY);
                parentToLocalTransformation.postTranslate(scaleCenterX, scaleCenterY);
            }
            this.mParentToLocalTransformationDirty = false;
        }
        return parentToLocalTransformation;
    }

    @Override
    public Transformation getLocalToSceneTransformation() {
        if (this.mLocalToSceneTransformation == null) {
            this.mLocalToSceneTransformation = new Transformation();
        }
        Transformation localToSceneTransformation = this.mLocalToSceneTransformation;
        localToSceneTransformation.setTo(this.getLocalToParentTransformation());
        IEntity parent = this.mParent;
        if (parent != null) {
            localToSceneTransformation.postConcat(parent.getLocalToSceneTransformation());
        }
        return localToSceneTransformation;
    }

    @Override
    public Transformation getSceneToLocalTransformation() {
        if (this.mSceneToLocalTransformation == null) {
            this.mSceneToLocalTransformation = new Transformation();
        }
        Transformation sceneToLocalTransformation = this.mSceneToLocalTransformation;
        sceneToLocalTransformation.setTo(this.getParentToLocalTransformation());
        IEntity parent = this.mParent;
        if (parent != null) {
            sceneToLocalTransformation.preConcat(parent.getSceneToLocalTransformation());
        }
        return sceneToLocalTransformation;
    }

    @Override
    public float[] convertLocalToSceneCoordinates(float pX, float pY) {
        return this.convertLocalToSceneCoordinates(pX, pY, VERTICES_LOCAL_TO_SCENE_TMP);
    }

    @Override
    public float[] convertLocalToSceneCoordinates(float pX, float pY, float[] pReuse) {
        Transformation localToSceneTransformation = this.getLocalToSceneTransformation();
        pReuse[0] = pX;
        pReuse[1] = pY;
        localToSceneTransformation.transform(pReuse);
        return pReuse;
    }

    @Override
    public float[] convertLocalToSceneCoordinates(float[] pCoordinates) {
        return this.convertLocalToSceneCoordinates(pCoordinates, VERTICES_LOCAL_TO_SCENE_TMP);
    }

    @Override
    public float[] convertLocalToSceneCoordinates(float[] pCoordinates, float[] pReuse) {
        Transformation localToSceneTransformation = this.getLocalToSceneTransformation();
        pReuse[0] = pCoordinates[0];
        pReuse[1] = pCoordinates[1];
        localToSceneTransformation.transform(pReuse);
        return pReuse;
    }

    @Override
    public float[] convertSceneToLocalCoordinates(float pX, float pY) {
        return this.convertSceneToLocalCoordinates(pX, pY, VERTICES_SCENE_TO_LOCAL_TMP);
    }

    @Override
    public float[] convertSceneToLocalCoordinates(float pX, float pY, float[] pReuse) {
        pReuse[0] = pX;
        pReuse[1] = pY;
        this.getSceneToLocalTransformation().transform(pReuse);
        return pReuse;
    }

    @Override
    public float[] convertSceneToLocalCoordinates(float[] pCoordinates) {
        return this.convertSceneToLocalCoordinates(pCoordinates, VERTICES_SCENE_TO_LOCAL_TMP);
    }

    @Override
    public float[] convertSceneToLocalCoordinates(float[] pCoordinates, float[] pReuse) {
        pReuse[0] = pCoordinates[0];
        pReuse[1] = pCoordinates[1];
        this.getSceneToLocalTransformation().transform(pReuse);
        return pReuse;
    }

    @Override
    public void onAttached() {
    }

    @Override
    public void onDetached() {
    }

    @Override
    public Object getUserData() {
        return this.mUserData;
    }

    @Override
    public void setUserData(Object pUserData) {
        this.mUserData = pUserData;
    }

    @Override
    public final void onDraw(GLState pGLState, Camera pCamera) {
        if (!(!this.mVisible || this.mCullingEnabled && this.isCulled(pCamera))) {
            this.onManagedDraw(pGLState, pCamera);
        }
    }

    @Override
    public final void onUpdate(float pSecondsElapsed) {
        if (!this.mIgnoreUpdate) {
            this.onManagedUpdate(pSecondsElapsed);
        }
    }

    @Override
    public void reset() {
        this.mVisible = true;
        this.mCullingEnabled = false;
        this.mIgnoreUpdate = false;
        this.mChildrenVisible = true;
        this.mChildrenIgnoreUpdate = false;
        this.mRotation = 0.0f;
        this.mScaleX = 1.0f;
        this.mScaleY = 1.0f;
        this.mSkewX = 0.0f;
        this.mSkewY = 0.0f;
        this.mColor.reset();
        if (this.mEntityModifiers != null) {
            this.mEntityModifiers.reset();
        }
        if (this.mChildren != null) {
            SmartList<IEntity> entities = this.mChildren;
            for (int i = entities.size() - 1; i >= 0; --i) {
                ((IEntity)entities.get(i)).reset();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.mDisposed) {
            throw new IDisposable.AlreadyDisposedException();
        }
        this.mDisposed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.mDisposed) {
            this.dispose();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder pStringBuilder) {
        pStringBuilder.append(this.getClass().getSimpleName());
        if (this.mChildren != null && this.mChildren.size() > 0) {
            pStringBuilder.append(" [");
            SmartList<IEntity> entities = this.mChildren;
            for (int i = 0; i < entities.size(); ++i) {
                ((IEntity)entities.get(i)).toString(pStringBuilder);
                if (i >= entities.size() - 1) continue;
                pStringBuilder.append(", ");
            }
            pStringBuilder.append("]");
        }
    }

    protected void preDraw(GLState pGLState, Camera pCamera) {
    }

    protected void draw(GLState pGLState, Camera pCamera) {
    }

    protected void postDraw(GLState pGLState, Camera pCamera) {
    }

    private void allocateEntityModifiers() {
        this.mEntityModifiers = new EntityModifierList(this, 4);
    }

    private void allocateChildren() {
        this.mChildren = new SmartList(4);
    }

    private void allocateUpdateHandlers() {
        this.mUpdateHandlers = new UpdateHandlerList(4);
    }

    protected void onApplyTransformations(GLState pGLState) {
        this.applyTranslation(pGLState);
        this.applyRotation(pGLState);
        this.applySkew(pGLState);
        this.applyScale(pGLState);
    }

    protected void applyTranslation(GLState pGLState) {
        pGLState.translateModelViewGLMatrixf(this.mX, this.mY, 0.0f);
    }

    protected void applyRotation(GLState pGLState) {
        float rotation = this.mRotation;
        if (rotation != 0.0f) {
            float rotationCenterX = this.mRotationCenterX;
            float rotationCenterY = this.mRotationCenterY;
            pGLState.translateModelViewGLMatrixf(rotationCenterX, rotationCenterY, 0.0f);
            pGLState.rotateModelViewGLMatrixf(rotation, 0.0f, 0.0f, 1.0f);
            pGLState.translateModelViewGLMatrixf(-rotationCenterX, -rotationCenterY, 0.0f);
        }
    }

    protected void applySkew(GLState pGLState) {
        float skewX = this.mSkewX;
        float skewY = this.mSkewY;
        if (skewX != 0.0f || skewY != 0.0f) {
            float skewCenterX = this.mSkewCenterX;
            float skewCenterY = this.mSkewCenterY;
            pGLState.translateModelViewGLMatrixf(skewCenterX, skewCenterY, 0.0f);
            pGLState.skewModelViewGLMatrixf(skewX, skewY);
            pGLState.translateModelViewGLMatrixf(-skewCenterX, -skewCenterY, 0.0f);
        }
    }

    protected void applyScale(GLState pGLState) {
        float scaleX = this.mScaleX;
        float scaleY = this.mScaleY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            float scaleCenterX = this.mScaleCenterX;
            float scaleCenterY = this.mScaleCenterY;
            pGLState.translateModelViewGLMatrixf(scaleCenterX, scaleCenterY, 0.0f);
            pGLState.scaleModelViewGLMatrixf(scaleX, scaleY, 1);
            pGLState.translateModelViewGLMatrixf(-scaleCenterX, -scaleCenterY, 0.0f);
        }
    }

    protected void onManagedDraw(GLState pGLState, Camera pCamera) {
        pGLState.pushModelViewGLMatrix();
        this.onApplyTransformations(pGLState);
        SmartList<IEntity> children = this.mChildren;
        if (children == null || !this.mChildrenVisible) {
            this.preDraw(pGLState, pCamera);
            this.draw(pGLState, pCamera);
            this.postDraw(pGLState, pCamera);
        } else {
            IEntity child;
            int i;
            if (this.mChildrenSortPending) {
                ZIndexSorter.getInstance().sort(this.mChildren);
                this.mChildrenSortPending = false;
            }
            int childCount = children.size();
            for (i = 0; i < childCount && (child = (IEntity)children.get(i)).getZIndex() < 0; ++i) {
                child.onDraw(pGLState, pCamera);
            }
            this.preDraw(pGLState, pCamera);
            this.draw(pGLState, pCamera);
            this.postDraw(pGLState, pCamera);
            while (i < childCount) {
                ((IEntity)children.get(i)).onDraw(pGLState, pCamera);
                ++i;
            }
        }
        pGLState.popModelViewGLMatrix();
    }

    protected void onManagedUpdate(float pSecondsElapsed) {
        if (this.mEntityModifiers != null) {
            this.mEntityModifiers.onUpdate(pSecondsElapsed);
        }
        if (this.mUpdateHandlers != null) {
            this.mUpdateHandlers.onUpdate(pSecondsElapsed);
        }
        if (this.mChildren != null && !this.mChildrenIgnoreUpdate) {
            SmartList<IEntity> entities = this.mChildren;
            int entityCount = entities.size();
            for (int i = 0; i < entityCount; ++i) {
                ((IEntity)entities.get(i)).onUpdate(pSecondsElapsed);
            }
        }
    }

    private void assertEntityHasNoParent(IEntity pEntity) throws IllegalStateException {
        if (pEntity.hasParent()) {
            String entityClassName = pEntity.getClass().getSimpleName();
            String currentParentClassName = pEntity.getParent().getClass().getSimpleName();
            String newParentClassName = this.getClass().getSimpleName();
            throw new IllegalStateException("pEntity '" + entityClassName + "' already has a parent: '" + currentParentClassName + "'. New parent: '" + newParentClassName + "'!");
        }
    }
}

