/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.modifier;

import org.andengine.entity.IEntity;
import org.andengine.entity.modifier.DurationEntityModifier;
import org.andengine.entity.modifier.IEntityModifier;
import org.andengine.util.modifier.ease.EaseLinear;
import org.andengine.util.modifier.ease.IEaseFunction;

public class CubicBezierCurveMoveModifier
extends DurationEntityModifier {
    private final float mX1;
    private final float mY1;
    private final float mX2;
    private final float mY2;
    private final float mX3;
    private final float mY3;
    private final float mX4;
    private final float mY4;
    private final IEaseFunction mEaseFunction;

    public CubicBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, float pX4, float pY4) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, pX4, pY4, null, EaseLinear.getInstance());
    }

    public CubicBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, float pX4, float pY4, IEaseFunction pEaseFunction) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, pX4, pY4, null, pEaseFunction);
    }

    public CubicBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, float pX4, float pY4, IEntityModifier.IEntityModifierListener pEntityModifierListener) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, pX4, pY4, pEntityModifierListener, EaseLinear.getInstance());
    }

    public CubicBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, float pX4, float pY4, IEntityModifier.IEntityModifierListener pEntityModifierListener, IEaseFunction pEaseFunction) {
        super(pDuration, pEntityModifierListener);
        this.mX1 = pX1;
        this.mY1 = pY1;
        this.mX2 = pX2;
        this.mY2 = pY2;
        this.mX3 = pX3;
        this.mY3 = pY3;
        this.mX4 = pX4;
        this.mY4 = pY4;
        this.mEaseFunction = pEaseFunction;
    }

    @Override
    public CubicBezierCurveMoveModifier deepCopy() {
        return new CubicBezierCurveMoveModifier(this.mDuration, this.mX1, this.mY1, this.mX2, this.mY2, this.mX3, this.mY3, this.mX4, this.mY4, this.mEaseFunction);
    }

    @Override
    protected void onManagedInitialize(IEntity pEntity) {
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed, IEntity pEntity) {
        float percentageDone = this.mEaseFunction.getPercentage(this.getSecondsElapsed(), this.mDuration);
        float u = 1.0f - percentageDone;
        float tt = percentageDone * percentageDone;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * percentageDone;
        float ut3 = 3.0f * uu * percentageDone;
        float utt3 = 3.0f * u * tt;
        float x = uuu * this.mX1 + ut3 * this.mX2 + utt3 * this.mX3 + ttt * this.mX4;
        float y = uuu * this.mY1 + ut3 * this.mY2 + utt3 * this.mY3 + ttt * this.mY4;
        pEntity.setPosition(x, y);
    }
}

