/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.modifier;

import org.andengine.entity.IEntity;
import org.andengine.entity.modifier.EntityModifier;
import org.andengine.entity.modifier.IEntityModifier;
import org.andengine.entity.modifier.MoveModifier;
import org.andengine.util.modifier.IModifier;
import org.andengine.util.modifier.SequenceModifier;
import org.andengine.util.modifier.ease.EaseLinear;
import org.andengine.util.modifier.ease.IEaseFunction;

public class PathModifier
extends EntityModifier {
    private final SequenceModifier<IEntity> mSequenceModifier;
    private IPathModifierListener mPathModifierListener;
    private final Path mPath;

    public PathModifier(float pDuration, Path pPath) {
        this(pDuration, pPath, null, null, EaseLinear.getInstance());
    }

    public PathModifier(float pDuration, Path pPath, IEaseFunction pEaseFunction) {
        this(pDuration, pPath, null, null, pEaseFunction);
    }

    public PathModifier(float pDuration, Path pPath, IEntityModifier.IEntityModifierListener pEntityModiferListener) {
        this(pDuration, pPath, pEntityModiferListener, null, EaseLinear.getInstance());
    }

    public PathModifier(float pDuration, Path pPath, IPathModifierListener pPathModifierListener) {
        this(pDuration, pPath, null, pPathModifierListener, EaseLinear.getInstance());
    }

    public PathModifier(float pDuration, Path pPath, IPathModifierListener pPathModifierListener, IEaseFunction pEaseFunction) {
        this(pDuration, pPath, null, pPathModifierListener, pEaseFunction);
    }

    public PathModifier(float pDuration, Path pPath, IEntityModifier.IEntityModifierListener pEntityModiferListener, IEaseFunction pEaseFunction) {
        this(pDuration, pPath, pEntityModiferListener, null, pEaseFunction);
    }

    public PathModifier(float pDuration, Path pPath, IEntityModifier.IEntityModifierListener pEntityModiferListener, IPathModifierListener pPathModifierListener) throws IllegalArgumentException {
        this(pDuration, pPath, pEntityModiferListener, pPathModifierListener, EaseLinear.getInstance());
    }

    public PathModifier(float pDuration, Path pPath, IEntityModifier.IEntityModifierListener pEntityModiferListener, IPathModifierListener pPathModifierListener, IEaseFunction pEaseFunction) throws IllegalArgumentException {
        super(pEntityModiferListener);
        int pathSize = pPath.getSize();
        if (pathSize < 2) {
            throw new IllegalArgumentException("Path needs at least 2 waypoints!");
        }
        this.mPath = pPath;
        this.mPathModifierListener = pPathModifierListener;
        MoveModifier[] moveModifiers = new MoveModifier[pathSize - 1];
        float[] coordinatesX = pPath.getCoordinatesX();
        float[] coordinatesY = pPath.getCoordinatesY();
        float velocity = pPath.getLength() / pDuration;
        int modifierCount = moveModifiers.length;
        for (int i = 0; i < modifierCount; ++i) {
            float duration = pPath.getSegmentLength(i) / velocity;
            moveModifiers[i] = new MoveModifier(duration, coordinatesX[i], coordinatesX[i + 1], coordinatesY[i], coordinatesY[i + 1], null, pEaseFunction);
        }
        this.mSequenceModifier = new SequenceModifier<IEntity>(new SequenceModifier.ISubSequenceModifierListener<IEntity>(){

            @Override
            public void onSubSequenceStarted(IModifier<IEntity> pModifier, IEntity pEntity, int pIndex) {
                if (PathModifier.this.mPathModifierListener != null) {
                    PathModifier.this.mPathModifierListener.onPathWaypointStarted(PathModifier.this, pEntity, pIndex);
                }
            }

            @Override
            public void onSubSequenceFinished(IModifier<IEntity> pEntityModifier, IEntity pEntity, int pIndex) {
                if (PathModifier.this.mPathModifierListener != null) {
                    PathModifier.this.mPathModifierListener.onPathWaypointFinished(PathModifier.this, pEntity, pIndex);
                }
            }
        }, new IEntityModifier.IEntityModifierListener(){

            @Override
            public void onModifierStarted(IModifier<IEntity> pModifier, IEntity pEntity) {
                PathModifier.this.onModifierStarted(pEntity);
                if (PathModifier.this.mPathModifierListener != null) {
                    PathModifier.this.mPathModifierListener.onPathStarted(PathModifier.this, pEntity);
                }
            }

            @Override
            public void onModifierFinished(IModifier<IEntity> pEntityModifier, IEntity pEntity) {
                PathModifier.this.onModifierFinished(pEntity);
                if (PathModifier.this.mPathModifierListener != null) {
                    PathModifier.this.mPathModifierListener.onPathFinished(PathModifier.this, pEntity);
                }
            }
        }, moveModifiers);
    }

    protected PathModifier(PathModifier pPathModifier) throws IModifier.DeepCopyNotSupportedException {
        this.mPath = pPathModifier.mPath.deepCopy();
        this.mSequenceModifier = pPathModifier.mSequenceModifier.deepCopy();
    }

    @Override
    public PathModifier deepCopy() throws IModifier.DeepCopyNotSupportedException {
        return new PathModifier(this);
    }

    public Path getPath() {
        return this.mPath;
    }

    @Override
    public boolean isFinished() {
        return this.mSequenceModifier.isFinished();
    }

    @Override
    public float getSecondsElapsed() {
        return this.mSequenceModifier.getSecondsElapsed();
    }

    @Override
    public float getDuration() {
        return this.mSequenceModifier.getDuration();
    }

    public IPathModifierListener getPathModifierListener() {
        return this.mPathModifierListener;
    }

    public void setPathModifierListener(IPathModifierListener pPathModifierListener) {
        this.mPathModifierListener = pPathModifierListener;
    }

    @Override
    public void reset() {
        this.mSequenceModifier.reset();
    }

    @Override
    public float onUpdate(float pSecondsElapsed, IEntity pEntity) {
        return this.mSequenceModifier.onUpdate(pSecondsElapsed, pEntity);
    }

    public static class Path {
        private final float[] mXs;
        private final float[] mYs;
        private int mIndex;
        private boolean mLengthChanged = false;
        private float mLength;

        public Path(int pLength) {
            this.mXs = new float[pLength];
            this.mYs = new float[pLength];
            this.mIndex = 0;
            this.mLengthChanged = false;
        }

        public Path(float[] pCoordinatesX, float[] pCoordinatesY) throws IllegalArgumentException {
            if (pCoordinatesX.length != pCoordinatesY.length) {
                throw new IllegalArgumentException("Coordinate-Arrays must have the same length.");
            }
            this.mXs = pCoordinatesX;
            this.mYs = pCoordinatesY;
            this.mIndex = pCoordinatesX.length;
            this.mLengthChanged = true;
        }

        public Path(Path pPath) {
            int size = pPath.getSize();
            this.mXs = new float[size];
            this.mYs = new float[size];
            System.arraycopy(pPath.mXs, 0, this.mXs, 0, size);
            System.arraycopy(pPath.mYs, 0, this.mYs, 0, size);
            this.mIndex = pPath.mIndex;
            this.mLengthChanged = pPath.mLengthChanged;
            this.mLength = pPath.mLength;
        }

        public Path deepCopy() {
            return new Path(this);
        }

        public Path to(float pX, float pY) {
            this.mXs[this.mIndex] = pX;
            this.mYs[this.mIndex] = pY;
            ++this.mIndex;
            this.mLengthChanged = true;
            return this;
        }

        public float[] getCoordinatesX() {
            return this.mXs;
        }

        public float[] getCoordinatesY() {
            return this.mYs;
        }

        public int getSize() {
            return this.mXs.length;
        }

        public float getLength() {
            if (this.mLengthChanged) {
                this.updateLength();
            }
            return this.mLength;
        }

        public float getSegmentLength(int pSegmentIndex) {
            float[] coordinatesX = this.mXs;
            float[] coordinatesY = this.mYs;
            int nextSegmentIndex = pSegmentIndex + 1;
            float dx = coordinatesX[pSegmentIndex] - coordinatesX[nextSegmentIndex];
            float dy = coordinatesY[pSegmentIndex] - coordinatesY[nextSegmentIndex];
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        private void updateLength() {
            float length = 0.0f;
            for (int i = this.mIndex - 2; i >= 0; --i) {
                length += this.getSegmentLength(i);
            }
            this.mLength = length;
        }
    }

    public static interface IPathModifierListener {
        public void onPathStarted(PathModifier var1, IEntity var2);

        public void onPathWaypointStarted(PathModifier var1, IEntity var2, int var3);

        public void onPathWaypointFinished(PathModifier var1, IEntity var2, int var3);

        public void onPathFinished(PathModifier var1, IEntity var2);
    }
}

