/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.modifier;

import org.andengine.entity.IEntity;
import org.andengine.entity.modifier.DurationEntityModifier;
import org.andengine.entity.modifier.IEntityModifier;
import org.andengine.util.modifier.ease.EaseLinear;
import org.andengine.util.modifier.ease.IEaseFunction;

public class QuadraticBezierCurveMoveModifier
extends DurationEntityModifier {
    private final float mX1;
    private final float mY1;
    private final float mX2;
    private final float mY2;
    private final float mX3;
    private final float mY3;
    private final IEaseFunction mEaseFunction;

    public QuadraticBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, EaseLinear.getInstance(), null);
    }

    public QuadraticBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, IEaseFunction pEaseFunction) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, pEaseFunction, null);
    }

    public QuadraticBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, IEntityModifier.IEntityModifierListener pEntityModifierListener) {
        this(pDuration, pX1, pY1, pX2, pY2, pX3, pY3, EaseLinear.getInstance(), pEntityModifierListener);
    }

    public QuadraticBezierCurveMoveModifier(float pDuration, float pX1, float pY1, float pX2, float pY2, float pX3, float pY3, IEaseFunction pEaseFunction, IEntityModifier.IEntityModifierListener pEntityModifierListener) {
        super(pDuration, pEntityModifierListener);
        this.mX1 = pX1;
        this.mY1 = pY1;
        this.mX2 = pX2;
        this.mY2 = pY2;
        this.mX3 = pX3;
        this.mY3 = pY3;
        this.mEaseFunction = pEaseFunction;
    }

    @Override
    public QuadraticBezierCurveMoveModifier deepCopy() {
        return new QuadraticBezierCurveMoveModifier(this.mDuration, this.mX1, this.mY1, this.mX2, this.mY2, this.mX3, this.mY3, this.mEaseFunction);
    }

    @Override
    protected void onManagedInitialize(IEntity pEntity) {
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed, IEntity pEntity) {
        float percentageDone = this.mEaseFunction.getPercentage(this.getSecondsElapsed(), this.mDuration);
        float u = 1.0f - percentageDone;
        float tt = percentageDone * percentageDone;
        float uu = u * u;
        float ut2 = 2.0f * u * percentageDone;
        float x = uu * this.mX1 + ut2 * this.mX2 + tt * this.mX3;
        float y = uu * this.mY1 + ut2 * this.mY2 + tt * this.mY3;
        pEntity.setPosition(x, y);
    }
}

