/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.particle.initializer;

import org.andengine.entity.IEntity;
import org.andengine.entity.particle.Particle;
import org.andengine.entity.particle.initializer.IParticleInitializer;
import org.andengine.util.math.MathUtils;

public abstract class BaseSingleValueParticleInitializer<T extends IEntity>
implements IParticleInitializer<T> {
    protected float mMinValue;
    protected float mMaxValue;

    public BaseSingleValueParticleInitializer(float pMinValue, float pMaxValue) {
        this.mMinValue = pMinValue;
        this.mMaxValue = pMaxValue;
    }

    protected abstract void onInitializeParticle(Particle<T> var1, float var2);

    @Override
    public final void onInitializeParticle(Particle<T> pParticle) {
        this.onInitializeParticle(pParticle, this.getRandomValue());
    }

    protected float getRandomValue() {
        if (this.mMinValue == this.mMaxValue) {
            return this.mMaxValue;
        }
        return MathUtils.random(this.mMinValue, this.mMaxValue);
    }
}

