/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.particle.modifier;

import org.andengine.entity.IEntity;
import org.andengine.entity.particle.Particle;
import org.andengine.entity.particle.modifier.IParticleModifier;
import org.andengine.util.modifier.ease.EaseLinear;
import org.andengine.util.modifier.ease.IEaseFunction;

public abstract class BaseSingleValueSpanParticleModifier<T extends IEntity>
implements IParticleModifier<T> {
    private float mFromTime;
    private float mToTime;
    private float mDuration;
    private float mFromValue;
    private float mValueSpan;
    private final IEaseFunction mEaseFunction;

    public BaseSingleValueSpanParticleModifier(float pFromTime, float pToTime, float pFromValue, float pToValue) {
        this(pFromTime, pToTime, pFromValue, pToValue, EaseLinear.getInstance());
    }

    public BaseSingleValueSpanParticleModifier(float pFromTime, float pToTime, float pFromValue, float pToValue, IEaseFunction pEaseFunction) {
        this.mFromTime = pFromTime;
        this.mToTime = pToTime;
        this.mDuration = pToTime - pFromTime;
        this.mFromValue = pFromValue;
        this.mValueSpan = pToValue - pFromValue;
        this.mEaseFunction = pEaseFunction;
    }

    protected abstract void onSetInitialValue(Particle<T> var1, float var2);

    protected abstract void onSetValue(Particle<T> var1, float var2, float var3);

    @Override
    public void onInitializeParticle(Particle<T> pParticle) {
        this.onSetInitialValue(pParticle, this.mFromValue);
    }

    @Override
    public void onUpdateParticle(Particle<T> pParticle) {
        float lifeTime = pParticle.getLifeTime();
        if (lifeTime > this.mFromTime && lifeTime < this.mToTime) {
            float percentageDone = this.mEaseFunction.getPercentage(lifeTime - this.mFromTime, this.mDuration);
            this.onSetValue(pParticle, percentageDone, this.mFromValue + percentageDone * this.mValueSpan);
        }
    }

    public void reset(float pFromValue, float pToValue, float pFromTime, float pToTime) {
        this.mFromValue = pFromValue;
        this.mFromTime = pFromTime;
        this.mToTime = pToTime;
        this.mValueSpan = pToValue - pFromValue;
        this.mDuration = pToTime - pFromTime;
    }
}

