/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.scene;

import android.util.SparseArray;
import org.andengine.engine.camera.Camera;
import org.andengine.engine.handler.runnable.RunnableHandler;
import org.andengine.entity.Entity;
import org.andengine.entity.IEntity;
import org.andengine.entity.scene.IOnAreaTouchListener;
import org.andengine.entity.scene.IOnSceneTouchListener;
import org.andengine.entity.scene.ITouchArea;
import org.andengine.entity.scene.background.Background;
import org.andengine.entity.scene.background.IBackground;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.util.GLState;
import org.andengine.util.adt.list.SmartList;
import org.andengine.util.color.Color;

public class Scene
extends Entity {
    private static final int TOUCHAREAS_CAPACITY_DEFAULT = 4;
    private float mSecondsElapsedTotal;
    protected Scene mParentScene;
    protected Scene mChildScene;
    private boolean mChildSceneModalDraw;
    private boolean mChildSceneModalUpdate;
    private boolean mChildSceneModalTouch;
    protected SmartList<ITouchArea> mTouchAreas = new SmartList(4);
    private final RunnableHandler mRunnableHandler = new RunnableHandler();
    private IOnSceneTouchListener mOnSceneTouchListener;
    private IOnAreaTouchListener mOnAreaTouchListener;
    private IBackground mBackground = new Background(Color.BLACK);
    private boolean mBackgroundEnabled = true;
    private boolean mOnAreaTouchTraversalBackToFront = true;
    private boolean mTouchAreaBindingOnActionDownEnabled = false;
    private boolean mTouchAreaBindingOnActionMoveEnabled = false;
    private final SparseArray<ITouchArea> mTouchAreaBindings = new SparseArray();
    private boolean mOnSceneTouchListenerBindingOnActionDownEnabled = false;
    private final SparseArray<IOnSceneTouchListener> mOnSceneTouchListenerBindings = new SparseArray();

    public Scene() {
    }

    @Deprecated
    public Scene(int pChildCount) {
        for (int i = 0; i < pChildCount; ++i) {
            this.attachChild(new Entity());
        }
    }

    public float getSecondsElapsedTotal() {
        return this.mSecondsElapsedTotal;
    }

    public IBackground getBackground() {
        return this.mBackground;
    }

    public void setBackground(IBackground pBackground) {
        this.mBackground = pBackground;
    }

    public boolean isBackgroundEnabled() {
        return this.mBackgroundEnabled;
    }

    public void setBackgroundEnabled(boolean pEnabled) {
        this.mBackgroundEnabled = pEnabled;
    }

    public void setOnSceneTouchListener(IOnSceneTouchListener pOnSceneTouchListener) {
        this.mOnSceneTouchListener = pOnSceneTouchListener;
    }

    public IOnSceneTouchListener getOnSceneTouchListener() {
        return this.mOnSceneTouchListener;
    }

    public boolean hasOnSceneTouchListener() {
        return this.mOnSceneTouchListener != null;
    }

    public void setOnAreaTouchListener(IOnAreaTouchListener pOnAreaTouchListener) {
        this.mOnAreaTouchListener = pOnAreaTouchListener;
    }

    public IOnAreaTouchListener getOnAreaTouchListener() {
        return this.mOnAreaTouchListener;
    }

    public boolean hasOnAreaTouchListener() {
        return this.mOnAreaTouchListener != null;
    }

    private void setParentScene(Scene pParentScene) {
        this.mParentScene = pParentScene;
    }

    public boolean hasChildScene() {
        return this.mChildScene != null;
    }

    public Scene getChildScene() {
        return this.mChildScene;
    }

    public void setChildSceneModal(Scene pChildScene) {
        this.setChildScene(pChildScene, true, true, true);
    }

    public void setChildScene(Scene pChildScene) {
        this.setChildScene(pChildScene, false, false, false);
    }

    public void setChildScene(Scene pChildScene, boolean pModalDraw, boolean pModalUpdate, boolean pModalTouch) {
        pChildScene.setParentScene(this);
        this.mChildScene = pChildScene;
        this.mChildSceneModalDraw = pModalDraw;
        this.mChildSceneModalUpdate = pModalUpdate;
        this.mChildSceneModalTouch = pModalTouch;
    }

    public void clearChildScene() {
        this.mChildScene = null;
    }

    public void setOnAreaTouchTraversalBackToFront() {
        this.mOnAreaTouchTraversalBackToFront = true;
    }

    public void setOnAreaTouchTraversalFrontToBack() {
        this.mOnAreaTouchTraversalBackToFront = false;
    }

    public boolean isTouchAreaBindingOnActionDownEnabled() {
        return this.mTouchAreaBindingOnActionDownEnabled;
    }

    public boolean isTouchAreaBindingOnActionMoveEnabled() {
        return this.mTouchAreaBindingOnActionMoveEnabled;
    }

    public void setTouchAreaBindingOnActionDownEnabled(boolean pTouchAreaBindingOnActionDownEnabled) {
        if (this.mTouchAreaBindingOnActionDownEnabled && !pTouchAreaBindingOnActionDownEnabled) {
            this.mTouchAreaBindings.clear();
        }
        this.mTouchAreaBindingOnActionDownEnabled = pTouchAreaBindingOnActionDownEnabled;
    }

    public void setTouchAreaBindingOnActionMoveEnabled(boolean pTouchAreaBindingOnActionMoveEnabled) {
        if (this.mTouchAreaBindingOnActionMoveEnabled && !pTouchAreaBindingOnActionMoveEnabled) {
            this.mTouchAreaBindings.clear();
        }
        this.mTouchAreaBindingOnActionMoveEnabled = pTouchAreaBindingOnActionMoveEnabled;
    }

    public boolean isOnSceneTouchListenerBindingOnActionDownEnabled() {
        return this.mOnSceneTouchListenerBindingOnActionDownEnabled;
    }

    public void setOnSceneTouchListenerBindingOnActionDownEnabled(boolean pOnSceneTouchListenerBindingOnActionDownEnabled) {
        if (this.mOnSceneTouchListenerBindingOnActionDownEnabled && !pOnSceneTouchListenerBindingOnActionDownEnabled) {
            this.mOnSceneTouchListenerBindings.clear();
        }
        this.mOnSceneTouchListenerBindingOnActionDownEnabled = pOnSceneTouchListenerBindingOnActionDownEnabled;
    }

    @Override
    protected void onManagedDraw(GLState pGLState, Camera pCamera) {
        Scene childScene = this.mChildScene;
        if (childScene == null || !this.mChildSceneModalDraw) {
            if (this.mBackgroundEnabled) {
                pGLState.pushProjectionGLMatrix();
                pCamera.onApplySceneBackgroundMatrix(pGLState);
                pGLState.loadModelViewGLMatrixIdentity();
                this.mBackground.onDraw(pGLState, pCamera);
                pGLState.popProjectionGLMatrix();
            }
            pGLState.pushProjectionGLMatrix();
            this.onApplyMatrix(pGLState, pCamera);
            pGLState.loadModelViewGLMatrixIdentity();
            super.onManagedDraw(pGLState, pCamera);
            pGLState.popProjectionGLMatrix();
        }
        if (childScene != null) {
            childScene.onDraw(pGLState, pCamera);
        }
    }

    protected void onApplyMatrix(GLState pGLState, Camera pCamera) {
        pCamera.onApplySceneMatrix(pGLState);
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed) {
        this.mSecondsElapsedTotal += pSecondsElapsed;
        this.mRunnableHandler.onUpdate(pSecondsElapsed);
        Scene childScene = this.mChildScene;
        if (childScene == null || !this.mChildSceneModalUpdate) {
            this.mBackground.onUpdate(pSecondsElapsed);
            super.onManagedUpdate(pSecondsElapsed);
        }
        if (childScene != null) {
            childScene.onUpdate(pSecondsElapsed);
        }
    }

    public boolean onSceneTouchEvent(TouchEvent pSceneTouchEvent) {
        int touchAreaCount;
        Scene childScene;
        Boolean handled;
        int action = pSceneTouchEvent.getAction();
        boolean isActionDown = pSceneTouchEvent.isActionDown();
        boolean isActionMove = pSceneTouchEvent.isActionMove();
        if (!isActionDown) {
            SparseArray<ITouchArea> touchAreaBindings;
            ITouchArea boundTouchArea;
            IOnSceneTouchListener boundOnSceneTouchListener;
            if (this.mOnSceneTouchListenerBindingOnActionDownEnabled && (boundOnSceneTouchListener = (IOnSceneTouchListener)this.mOnSceneTouchListenerBindings.get(pSceneTouchEvent.getPointerID())) != null) {
                switch (action) {
                    case 1: 
                    case 3: {
                        this.mOnSceneTouchListenerBindings.remove(pSceneTouchEvent.getPointerID());
                    }
                }
                Boolean handled2 = this.mOnSceneTouchListener.onSceneTouchEvent(this, pSceneTouchEvent);
                if (handled2 != null && handled2.booleanValue()) {
                    return true;
                }
            }
            if (this.mTouchAreaBindingOnActionDownEnabled && (boundTouchArea = (ITouchArea)(touchAreaBindings = this.mTouchAreaBindings).get(pSceneTouchEvent.getPointerID())) != null) {
                float sceneTouchEventX = pSceneTouchEvent.getX();
                float sceneTouchEventY = pSceneTouchEvent.getY();
                switch (action) {
                    case 1: 
                    case 3: {
                        touchAreaBindings.remove(pSceneTouchEvent.getPointerID());
                    }
                }
                handled = this.onAreaTouchEvent(pSceneTouchEvent, sceneTouchEventX, sceneTouchEventY, boundTouchArea);
                if (handled != null && handled.booleanValue()) {
                    return true;
                }
            }
        }
        if ((childScene = this.mChildScene) != null) {
            boolean handledByChild = this.onChildSceneTouchEvent(pSceneTouchEvent);
            if (handledByChild) {
                return true;
            }
            if (this.mChildSceneModalTouch) {
                return false;
            }
        }
        float sceneTouchEventX = pSceneTouchEvent.getX();
        float sceneTouchEventY = pSceneTouchEvent.getY();
        SmartList<ITouchArea> touchAreas = this.mTouchAreas;
        if (touchAreas != null && (touchAreaCount = touchAreas.size()) > 0) {
            if (this.mOnAreaTouchTraversalBackToFront) {
                for (int i = 0; i < touchAreaCount; ++i) {
                    Boolean handled3;
                    ITouchArea touchArea = (ITouchArea)touchAreas.get(i);
                    if (!touchArea.contains(sceneTouchEventX, sceneTouchEventY) || (handled3 = this.onAreaTouchEvent(pSceneTouchEvent, sceneTouchEventX, sceneTouchEventY, touchArea)) == null || !handled3.booleanValue()) continue;
                    if (this.mTouchAreaBindingOnActionDownEnabled && isActionDown || this.mTouchAreaBindingOnActionMoveEnabled && isActionMove) {
                        this.mTouchAreaBindings.put(pSceneTouchEvent.getPointerID(), (Object)touchArea);
                    }
                    return true;
                }
            } else {
                for (int i = touchAreaCount - 1; i >= 0; --i) {
                    Boolean handled4;
                    ITouchArea touchArea = (ITouchArea)touchAreas.get(i);
                    if (!touchArea.contains(sceneTouchEventX, sceneTouchEventY) || (handled4 = this.onAreaTouchEvent(pSceneTouchEvent, sceneTouchEventX, sceneTouchEventY, touchArea)) == null || !handled4.booleanValue()) continue;
                    if (this.mTouchAreaBindingOnActionDownEnabled && isActionDown || this.mTouchAreaBindingOnActionMoveEnabled && isActionMove) {
                        this.mTouchAreaBindings.put(pSceneTouchEvent.getPointerID(), (Object)touchArea);
                    }
                    return true;
                }
            }
        }
        if (this.mOnSceneTouchListener != null) {
            handled = this.mOnSceneTouchListener.onSceneTouchEvent(this, pSceneTouchEvent);
            if (handled != null && handled.booleanValue()) {
                if (this.mOnSceneTouchListenerBindingOnActionDownEnabled && isActionDown) {
                    this.mOnSceneTouchListenerBindings.put(pSceneTouchEvent.getPointerID(), (Object)this.mOnSceneTouchListener);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private Boolean onAreaTouchEvent(TouchEvent pSceneTouchEvent, float sceneTouchEventX, float sceneTouchEventY, ITouchArea touchArea) {
        float touchAreaLocalY;
        float[] touchAreaLocalCoordinates = touchArea.convertSceneToLocalCoordinates(sceneTouchEventX, sceneTouchEventY);
        float touchAreaLocalX = touchAreaLocalCoordinates[0];
        boolean handledSelf = touchArea.onAreaTouched(pSceneTouchEvent, touchAreaLocalX, touchAreaLocalY = touchAreaLocalCoordinates[1]);
        if (handledSelf) {
            return Boolean.TRUE;
        }
        if (this.mOnAreaTouchListener != null) {
            return this.mOnAreaTouchListener.onAreaTouched(pSceneTouchEvent, touchArea, touchAreaLocalX, touchAreaLocalY);
        }
        return null;
    }

    protected boolean onChildSceneTouchEvent(TouchEvent pSceneTouchEvent) {
        return this.mChildScene.onSceneTouchEvent(pSceneTouchEvent);
    }

    @Override
    public void reset() {
        super.reset();
        this.clearChildScene();
    }

    @Override
    public void setParent(IEntity pEntity) {
    }

    public void postRunnable(Runnable pRunnable) {
        this.mRunnableHandler.postRunnable(pRunnable);
    }

    public void registerTouchArea(ITouchArea pTouchArea) {
        this.mTouchAreas.add(pTouchArea);
    }

    public boolean unregisterTouchArea(ITouchArea pTouchArea) {
        return this.mTouchAreas.remove(pTouchArea);
    }

    public boolean unregisterTouchAreas(ITouchArea.ITouchAreaMatcher pTouchAreaMatcher) {
        return this.mTouchAreas.removeAll(pTouchAreaMatcher);
    }

    public void clearTouchAreas() {
        this.mTouchAreas.clear();
    }

    public SmartList<ITouchArea> getTouchAreas() {
        return this.mTouchAreas;
    }

    public void back() {
        this.clearChildScene();
        if (this.mParentScene != null) {
            this.mParentScene.clearChildScene();
            this.mParentScene = null;
        }
    }
}

