/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.scene.background;

import android.opengl.GLES20;
import org.andengine.engine.camera.Camera;
import org.andengine.entity.scene.background.IBackground;
import org.andengine.opengl.util.GLState;
import org.andengine.util.color.Color;
import org.andengine.util.modifier.IModifier;
import org.andengine.util.modifier.ModifierList;

public class Background
implements IBackground {
    private static final int BACKGROUNDMODIFIERS_CAPACITY_DEFAULT = 4;
    private ModifierList<IBackground> mBackgroundModifiers = null;
    private final Color mColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private boolean mColorEnabled = true;

    protected Background() {
    }

    public Background(float pRed, float pGreen, float pBlue) {
        this.mColor.set(pRed, pGreen, pBlue);
    }

    public Background(float pRed, float pGreen, float pBlue, float pAlpha) {
        this.mColor.set(pRed, pGreen, pBlue, pAlpha);
    }

    public Background(Color pColor) {
        this.mColor.set(pColor);
    }

    @Override
    public void setColor(float pRed, float pGreen, float pBlue) {
        this.mColor.set(pRed, pGreen, pBlue);
    }

    @Override
    public void setColor(float pRed, float pGreen, float pBlue, float pAlpha) {
        this.mColor.set(pRed, pGreen, pBlue, pAlpha);
    }

    @Override
    public void setColor(Color pColor) {
        this.mColor.set(pColor);
    }

    @Override
    public boolean isColorEnabled() {
        return this.mColorEnabled;
    }

    @Override
    public void setColorEnabled(boolean pColorEnabled) {
        this.mColorEnabled = pColorEnabled;
    }

    @Override
    public void registerBackgroundModifier(IModifier<IBackground> pBackgroundModifier) {
        if (this.mBackgroundModifiers == null) {
            this.allocateBackgroundModifiers();
        }
        this.mBackgroundModifiers.add(pBackgroundModifier);
    }

    @Override
    public boolean unregisterBackgroundModifier(IModifier<IBackground> pBackgroundModifier) {
        if (this.mBackgroundModifiers != null) {
            return this.mBackgroundModifiers.remove(pBackgroundModifier);
        }
        return false;
    }

    @Override
    public void clearBackgroundModifiers() {
        if (this.mBackgroundModifiers != null) {
            this.mBackgroundModifiers.clear();
        }
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        if (this.mBackgroundModifiers != null) {
            this.mBackgroundModifiers.onUpdate(pSecondsElapsed);
        }
    }

    @Override
    public void onDraw(GLState pGLState, Camera pCamera) {
        if (this.mColorEnabled) {
            GLES20.glClearColor((float)this.mColor.getRed(), (float)this.mColor.getGreen(), (float)this.mColor.getBlue(), (float)this.mColor.getAlpha());
            GLES20.glClear((int)16384);
        }
    }

    @Override
    public void reset() {
        this.mBackgroundModifiers.reset();
    }

    private void allocateBackgroundModifiers() {
        this.mBackgroundModifiers = new ModifierList<Background>(this, 4);
    }
}

