/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.scene.menu;

import java.util.ArrayList;
import org.andengine.engine.camera.Camera;
import org.andengine.entity.scene.CameraScene;
import org.andengine.entity.scene.IOnAreaTouchListener;
import org.andengine.entity.scene.IOnSceneTouchListener;
import org.andengine.entity.scene.ITouchArea;
import org.andengine.entity.scene.Scene;
import org.andengine.entity.scene.menu.animator.IMenuAnimator;
import org.andengine.entity.scene.menu.item.IMenuItem;
import org.andengine.input.touch.TouchEvent;

public class MenuScene
extends CameraScene
implements IOnAreaTouchListener,
IOnSceneTouchListener {
    protected final ArrayList<IMenuItem> mMenuItems = new ArrayList();
    private IOnMenuItemClickListener mOnMenuItemClickListener;
    private IMenuAnimator mMenuAnimator = IMenuAnimator.DEFAULT;
    private IMenuItem mSelectedMenuItem;

    public MenuScene() {
        this(null, null);
    }

    public MenuScene(IOnMenuItemClickListener pOnMenuItemClickListener) {
        this(null, pOnMenuItemClickListener);
    }

    public MenuScene(Camera pCamera) {
        this(pCamera, null);
    }

    public MenuScene(Camera pCamera, IOnMenuItemClickListener pOnMenuItemClickListener) {
        super(pCamera);
        this.mOnMenuItemClickListener = pOnMenuItemClickListener;
        this.setOnSceneTouchListener(this);
        this.setOnAreaTouchListener(this);
    }

    public IOnMenuItemClickListener getOnMenuItemClickListener() {
        return this.mOnMenuItemClickListener;
    }

    public void setOnMenuItemClickListener(IOnMenuItemClickListener pOnMenuItemClickListener) {
        this.mOnMenuItemClickListener = pOnMenuItemClickListener;
    }

    public int getMenuItemCount() {
        return this.mMenuItems.size();
    }

    public void addMenuItem(IMenuItem pMenuItem) {
        this.mMenuItems.add(pMenuItem);
        this.attachChild(pMenuItem);
        this.registerTouchArea(pMenuItem);
    }

    public void clearMenuItems() {
        for (int i = this.mMenuItems.size() - 1; i >= 0; --i) {
            IMenuItem menuItem = this.mMenuItems.remove(i);
            this.detachChild(menuItem);
            this.unregisterTouchArea(menuItem);
        }
    }

    @Override
    public MenuScene getChildScene() {
        return (MenuScene)super.getChildScene();
    }

    @Override
    public void setChildScene(Scene pChildScene, boolean pModalDraw, boolean pModalUpdate, boolean pModalTouch) throws IllegalArgumentException {
        if (!(pChildScene instanceof MenuScene)) {
            throw new IllegalArgumentException("MenuScene accepts only MenuScenes as a ChildScene.");
        }
        super.setChildScene(pChildScene, pModalDraw, pModalUpdate, pModalTouch);
    }

    @Override
    public void clearChildScene() {
        if (this.getChildScene() != null) {
            this.getChildScene().reset();
            super.clearChildScene();
        }
    }

    public void setMenuAnimator(IMenuAnimator pMenuAnimator) {
        this.mMenuAnimator = pMenuAnimator;
    }

    @Override
    public boolean onAreaTouched(TouchEvent pSceneTouchEvent, ITouchArea pTouchArea, float pTouchAreaLocalX, float pTouchAreaLocalY) {
        IMenuItem menuItem = (IMenuItem)pTouchArea;
        switch (pSceneTouchEvent.getAction()) {
            case 0: 
            case 2: {
                if (this.mSelectedMenuItem != null && this.mSelectedMenuItem != menuItem) {
                    this.mSelectedMenuItem.onUnselected();
                }
                this.mSelectedMenuItem = menuItem;
                this.mSelectedMenuItem.onSelected();
                break;
            }
            case 1: {
                if (this.mOnMenuItemClickListener == null) break;
                boolean handled = this.mOnMenuItemClickListener.onMenuItemClicked(this, menuItem, pTouchAreaLocalX, pTouchAreaLocalY);
                menuItem.onUnselected();
                this.mSelectedMenuItem = null;
                return handled;
            }
            case 3: {
                menuItem.onUnselected();
                this.mSelectedMenuItem = null;
            }
        }
        return true;
    }

    @Override
    public boolean onSceneTouchEvent(Scene pScene, TouchEvent pSceneTouchEvent) {
        if (this.mSelectedMenuItem != null) {
            this.mSelectedMenuItem.onUnselected();
            this.mSelectedMenuItem = null;
        }
        return false;
    }

    @Override
    public void back() {
        super.back();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        ArrayList<IMenuItem> menuItems = this.mMenuItems;
        for (int i = menuItems.size() - 1; i >= 0; --i) {
            menuItems.get(i).reset();
        }
        this.prepareAnimations();
    }

    public void closeMenuScene() {
        this.back();
    }

    public void buildAnimations() {
        this.prepareAnimations();
        float cameraWidthRaw = this.mCamera.getWidthRaw();
        float cameraHeightRaw = this.mCamera.getHeightRaw();
        this.mMenuAnimator.buildAnimations(this.mMenuItems, cameraWidthRaw, cameraHeightRaw);
    }

    public void prepareAnimations() {
        float cameraWidthRaw = this.mCamera.getWidthRaw();
        float cameraHeightRaw = this.mCamera.getHeightRaw();
        this.mMenuAnimator.prepareAnimations(this.mMenuItems, cameraWidthRaw, cameraHeightRaw);
    }

    public static interface IOnMenuItemClickListener {
        public boolean onMenuItemClicked(MenuScene var1, IMenuItem var2, float var3, float var4);
    }
}

