/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.scene.menu.animator;

import java.util.ArrayList;
import org.andengine.entity.scene.menu.animator.BaseMenuAnimator;
import org.andengine.entity.scene.menu.item.IMenuItem;
import org.andengine.util.HorizontalAlign;

public class DirectMenuAnimator
extends BaseMenuAnimator {
    public DirectMenuAnimator() {
    }

    public DirectMenuAnimator(HorizontalAlign pHorizontalAlign) {
        super(pHorizontalAlign);
    }

    public DirectMenuAnimator(float pMenuItemSpacing) {
        super(pMenuItemSpacing);
    }

    public DirectMenuAnimator(HorizontalAlign pHorizontalAlign, float pMenuItemSpacing) {
        super(pHorizontalAlign, pMenuItemSpacing);
    }

    @Override
    public void buildAnimations(ArrayList<IMenuItem> pMenuItems, float pCameraWidth, float pCameraHeight) {
    }

    @Override
    public void prepareAnimations(ArrayList<IMenuItem> pMenuItems, float pCameraWidth, float pCameraHeight) {
        float maximumWidth = this.getMaximumWidth(pMenuItems);
        float overallHeight = this.getOverallHeight(pMenuItems);
        float baseX = (pCameraWidth - maximumWidth) * 0.5f;
        float baseY = (pCameraHeight - overallHeight) * 0.5f;
        float menuItemSpacing = this.mMenuItemSpacing;
        float offsetY = 0.0f;
        int menuItemCount = pMenuItems.size();
        for (int i = 0; i < menuItemCount; ++i) {
            float offsetX;
            IMenuItem menuItem = pMenuItems.get(i);
            switch (this.mHorizontalAlign) {
                case LEFT: {
                    offsetX = 0.0f;
                    break;
                }
                case RIGHT: {
                    offsetX = maximumWidth - menuItem.getWidthScaled();
                    break;
                }
                default: {
                    offsetX = (maximumWidth - menuItem.getWidthScaled()) * 0.5f;
                }
            }
            menuItem.setPosition(baseX + offsetX, baseY + offsetY);
            offsetY += menuItem.getHeight() + menuItemSpacing;
        }
    }
}

