/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.shape;

import org.andengine.engine.camera.Camera;
import org.andengine.entity.primitive.Line;
import org.andengine.entity.shape.IAreaShape;
import org.andengine.entity.shape.IShape;
import org.andengine.entity.shape.Shape;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.util.algorithm.collision.RectangularShapeCollisionChecker;

public abstract class RectangularShape
extends Shape
implements IAreaShape {
    protected float mWidth;
    protected float mHeight;

    public RectangularShape(float pX, float pY, float pWidth, float pHeight, ShaderProgram pShaderProgram) {
        super(pX, pY, pShaderProgram);
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        this.resetRotationCenter();
        this.resetScaleCenter();
        this.resetSkewCenter();
    }

    @Override
    public float getWidth() {
        return this.mWidth;
    }

    @Override
    public float getHeight() {
        return this.mHeight;
    }

    @Override
    public void setWidth(float pWidth) {
        this.mWidth = pWidth;
        this.onUpdateVertices();
    }

    @Override
    public void setHeight(float pHeight) {
        this.mHeight = pHeight;
        this.onUpdateVertices();
    }

    @Override
    public void setSize(float pWidth, float pHeight) {
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        this.onUpdateVertices();
    }

    @Override
    public float getWidthScaled() {
        return this.getWidth() * this.mScaleX;
    }

    @Override
    public float getHeightScaled() {
        return this.getHeight() * this.mScaleY;
    }

    @Override
    public boolean isCulled(Camera pCamera) {
        return !RectangularShapeCollisionChecker.isVisible(pCamera, this);
    }

    @Override
    public void reset() {
        super.reset();
        this.resetRotationCenter();
        this.resetSkewCenter();
        this.resetScaleCenter();
    }

    @Override
    public boolean contains(float pX, float pY) {
        return RectangularShapeCollisionChecker.checkContains(this, pX, pY);
    }

    @Override
    public float[] getSceneCenterCoordinates() {
        return this.convertLocalToSceneCoordinates(this.mWidth * 0.5f, this.mHeight * 0.5f);
    }

    @Override
    public float[] getSceneCenterCoordinates(float[] pReuse) {
        return this.convertLocalToSceneCoordinates(this.mWidth * 0.5f, this.mHeight * 0.5f, pReuse);
    }

    @Override
    public boolean collidesWith(IShape pOtherShape) {
        if (pOtherShape instanceof RectangularShape) {
            return RectangularShapeCollisionChecker.checkCollision(this, (RectangularShape)pOtherShape);
        }
        if (pOtherShape instanceof Line) {
            return RectangularShapeCollisionChecker.checkCollision(this, (Line)pOtherShape);
        }
        return false;
    }

    public void resetRotationCenter() {
        this.mRotationCenterX = this.mWidth * 0.5f;
        this.mRotationCenterY = this.mHeight * 0.5f;
    }

    public void resetScaleCenter() {
        this.mScaleCenterX = this.mWidth * 0.5f;
        this.mScaleCenterY = this.mHeight * 0.5f;
    }

    public void resetSkewCenter() {
        this.mSkewCenterX = this.mWidth * 0.5f;
        this.mSkewCenterY = this.mHeight * 0.5f;
    }
}

