/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.shape;

import org.andengine.engine.camera.Camera;
import org.andengine.entity.Entity;
import org.andengine.entity.shape.IShape;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.IVertexBufferObject;
import org.andengine.opengl.vbo.VertexBufferObjectManager;

public abstract class Shape
extends Entity
implements IShape {
    protected int mBlendFunctionSource = 770;
    protected int mBlendFunctionDestination = 771;
    protected boolean mBlendingEnabled = false;
    protected ShaderProgram mShaderProgram;

    public Shape(float pX, float pY, ShaderProgram pShaderProgram) {
        super(pX, pY);
        this.mShaderProgram = pShaderProgram;
    }

    @Override
    public boolean isBlendingEnabled() {
        return this.mBlendingEnabled;
    }

    @Override
    public void setBlendingEnabled(boolean pBlendingEnabled) {
        this.mBlendingEnabled = pBlendingEnabled;
    }

    @Override
    public int getBlendFunctionSource() {
        return this.mBlendFunctionSource;
    }

    @Override
    public void setBlendFunctionSource(int pBlendFunctionSource) {
        this.mBlendFunctionSource = pBlendFunctionSource;
    }

    @Override
    public int getBlendFunctionDestination() {
        return this.mBlendFunctionDestination;
    }

    @Override
    public void setBlendFunctionDestination(int pBlendFunctionDestination) {
        this.mBlendFunctionDestination = pBlendFunctionDestination;
    }

    @Override
    public void setBlendFunction(int pBlendFunctionSource, int pBlendFunctionDestination) {
        this.mBlendFunctionSource = pBlendFunctionSource;
        this.mBlendFunctionDestination = pBlendFunctionDestination;
    }

    @Override
    public ShaderProgram getShaderProgram() {
        return this.mShaderProgram;
    }

    @Override
    public void setShaderProgram(ShaderProgram pShaderProgram) {
        this.mShaderProgram = pShaderProgram;
    }

    @Override
    public VertexBufferObjectManager getVertexBufferObjectManager() {
        return this.getVertexBufferObject().getVertexBufferObjectManager();
    }

    protected abstract void onUpdateVertices();

    @Override
    protected void preDraw(GLState pGLState, Camera pCamera) {
        if (this.mBlendingEnabled) {
            pGLState.enableBlend();
            pGLState.blendFunction(this.mBlendFunctionSource, this.mBlendFunctionDestination);
        }
    }

    @Override
    protected void postDraw(GLState pGLState, Camera pCamera) {
        if (this.mBlendingEnabled) {
            pGLState.disableBlend();
        }
    }

    @Override
    public boolean onAreaTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.mBlendFunctionSource = 770;
        this.mBlendFunctionDestination = 771;
    }

    @Override
    public void dispose() {
        super.dispose();
        IVertexBufferObject vertexBufferObject = this.getVertexBufferObject();
        if (vertexBufferObject != null && vertexBufferObject.isAutoDispose() && !vertexBufferObject.isDisposed()) {
            vertexBufferObject.dispose();
        }
    }

    protected void initBlendFunction(ITextureRegion pTextureRegion) {
        this.initBlendFunction(pTextureRegion.getTexture());
    }

    protected void initBlendFunction(ITexture pTexture) {
        this.initBlendFunction(pTexture.getTextureOptions());
    }

    protected void initBlendFunction(TextureOptions pTextureOptions) {
        if (pTextureOptions.mPreMultiplyAlpha) {
            this.setBlendFunction(1, 771);
        }
    }
}

