/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.sprite;

import org.andengine.entity.sprite.AnimationData;
import org.andengine.entity.sprite.IAnimationData;
import org.andengine.entity.sprite.TiledSprite;
import org.andengine.entity.sprite.vbo.ITiledSpriteVertexBufferObject;
import org.andengine.opengl.shader.PositionColorTextureCoordinatesShaderProgram;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.opengl.texture.region.ITiledTextureRegion;
import org.andengine.opengl.vbo.DrawType;
import org.andengine.opengl.vbo.VertexBufferObjectManager;

public class AnimatedSprite
extends TiledSprite {
    private static final int FRAMEINDEX_INVALID = -1;
    private boolean mAnimationRunning;
    private boolean mAnimationStartedFired;
    private int mCurrentFrameIndex;
    private long mAnimationProgress;
    private int mRemainingLoopCount;
    private final IAnimationData mAnimationData = new AnimationData();
    private IAnimationListener mAnimationListener;

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        super(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager, DrawType.DYNAMIC);
    }

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, ShaderProgram pShaderProgram) {
        super(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager, DrawType.DYNAMIC, pShaderProgram);
    }

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, DrawType pDrawType) {
        super(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager, pDrawType);
    }

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, DrawType pDrawType, ShaderProgram pShaderProgram) {
        super(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager, pDrawType, pShaderProgram);
    }

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, ITiledSpriteVertexBufferObject pTiledSpriteVertexBufferObject) {
        super(pX, pY, pTiledTextureRegion, pTiledSpriteVertexBufferObject);
    }

    public AnimatedSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, ITiledSpriteVertexBufferObject pTiledSpriteVertexBufferObject, ShaderProgram pShaderProgram) {
        super(pX, pY, pTiledTextureRegion, pTiledSpriteVertexBufferObject, pShaderProgram);
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pVertexBufferObjectManager, DrawType.DYNAMIC);
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, ShaderProgram pShaderProgram) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pVertexBufferObjectManager, DrawType.DYNAMIC, pShaderProgram);
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, DrawType pDrawType) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pVertexBufferObjectManager, pDrawType);
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, DrawType pDrawType, ShaderProgram pShaderProgram) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pVertexBufferObjectManager, pDrawType, pShaderProgram);
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, ITiledSpriteVertexBufferObject pTiledSpriteVertexBufferObject) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pTiledSpriteVertexBufferObject, (ShaderProgram)PositionColorTextureCoordinatesShaderProgram.getInstance());
    }

    public AnimatedSprite(float pX, float pY, float pWidth, float pHeight, ITiledTextureRegion pTiledTextureRegion, ITiledSpriteVertexBufferObject pTiledSpriteVertexBufferObject, ShaderProgram pShaderProgram) {
        super(pX, pY, pWidth, pHeight, pTiledTextureRegion, pTiledSpriteVertexBufferObject, pShaderProgram);
    }

    public boolean isAnimationRunning() {
        return this.mAnimationRunning;
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed) {
        super.onManagedUpdate(pSecondsElapsed);
        if (this.mAnimationRunning) {
            int loopCount = this.mAnimationData.getLoopCount();
            int[] frames = this.mAnimationData.getFrames();
            long animationDuration = this.mAnimationData.getAnimationDuration();
            if (!this.mAnimationStartedFired && this.mAnimationProgress == 0L) {
                this.mAnimationStartedFired = true;
                if (frames == null) {
                    this.setCurrentTileIndex(this.mAnimationData.getFirstFrameIndex());
                } else {
                    this.setCurrentTileIndex(frames[0]);
                }
                this.mCurrentFrameIndex = 0;
                if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationStarted(this, loopCount);
                    this.mAnimationListener.onAnimationFrameChanged(this, -1, 0);
                }
            }
            long nanoSecondsElapsed = (long)(pSecondsElapsed * 1.0E9f);
            this.mAnimationProgress += nanoSecondsElapsed;
            if (loopCount == -1) {
                while (this.mAnimationProgress > animationDuration) {
                    this.mAnimationProgress -= animationDuration;
                    if (this.mAnimationListener == null) continue;
                    this.mAnimationListener.onAnimationLoopFinished(this, this.mRemainingLoopCount, loopCount);
                }
            } else {
                while (this.mAnimationProgress > animationDuration) {
                    this.mAnimationProgress -= animationDuration;
                    --this.mRemainingLoopCount;
                    if (this.mRemainingLoopCount >= 0) {
                        if (this.mAnimationListener == null) continue;
                        this.mAnimationListener.onAnimationLoopFinished(this, this.mRemainingLoopCount, loopCount);
                        continue;
                    }
                    break;
                }
            }
            if (loopCount == -1 || this.mRemainingLoopCount >= 0) {
                int newFrameIndex = this.mAnimationData.calculateCurrentFrameIndex(this.mAnimationProgress);
                if (this.mCurrentFrameIndex != newFrameIndex) {
                    if (frames == null) {
                        this.setCurrentTileIndex(this.mAnimationData.getFirstFrameIndex() + newFrameIndex);
                    } else {
                        this.setCurrentTileIndex(frames[newFrameIndex]);
                    }
                    if (this.mAnimationListener != null) {
                        this.mAnimationListener.onAnimationFrameChanged(this, this.mCurrentFrameIndex, newFrameIndex);
                    }
                }
                this.mCurrentFrameIndex = newFrameIndex;
            } else {
                this.mAnimationRunning = false;
                if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationFinished(this);
                }
            }
        }
    }

    public void stopAnimation() {
        this.mAnimationRunning = false;
    }

    public void stopAnimation(int pTileIndex) {
        this.mAnimationRunning = false;
        this.setCurrentTileIndex(pTileIndex);
    }

    public void animate(long pFrameDurationEach) {
        this.animate(pFrameDurationEach, null);
    }

    public void animate(long pFrameDurationEach, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurationEach, this.getTileCount());
        this.initAnimation(pAnimationListener);
    }

    public void animate(long pFrameDurationEach, boolean pLoop) {
        this.animate(pFrameDurationEach, pLoop, null);
    }

    public void animate(long pFrameDurationEach, boolean pLoop, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurationEach, this.getTileCount(), pLoop);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long pFrameDurationEach, int pLoopCount) {
        this.animate(pFrameDurationEach, pLoopCount, null);
    }

    public void animate(long pFrameDurationEach, int pLoopCount, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurationEach, this.getTileCount(), pLoopCount);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations) {
        this.animate(pFrameDurations, (IAnimationListener)null);
    }

    public void animate(long[] pFrameDurations, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, boolean pLoop) {
        this.animate(pFrameDurations, pLoop, null);
    }

    public void animate(long[] pFrameDurations, boolean pLoop, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pLoop);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int pLoopCount) {
        this.animate(pFrameDurations, pLoopCount, null);
    }

    public void animate(long[] pFrameDurations, int pLoopCount, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pLoopCount);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int pFirstTileIndex, int pLastTileIndex, boolean pLoop) {
        this.animate(pFrameDurations, pFirstTileIndex, pLastTileIndex, pLoop, null);
    }

    public void animate(long[] pFrameDurations, int pFirstTileIndex, int pLastTileIndex, boolean pLoop, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pFirstTileIndex, pLastTileIndex, pLoop);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int pFirstTileIndex, int pLastTileIndex, int pLoopCount) {
        this.animate(pFrameDurations, pFirstTileIndex, pLastTileIndex, pLoopCount, null);
    }

    public void animate(long[] pFrameDurations, int pFirstTileIndex, int pLastTileIndex, int pLoopCount, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pFirstTileIndex, pLastTileIndex, pLoopCount);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int[] pFrames) {
        this.animate(pFrameDurations, pFrames, null);
    }

    public void animate(long[] pFrameDurations, int[] pFrames, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pFrames);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int[] pFrames, boolean pLoop) {
        this.animate(pFrameDurations, pFrames, pLoop, null);
    }

    public void animate(long[] pFrameDurations, int[] pFrames, boolean pLoop, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pFrames, pLoop);
        this.initAnimation(pAnimationListener);
    }

    public void animate(long[] pFrameDurations, int[] pFrames, int pLoopCount) {
        this.animate(pFrameDurations, pFrames, pLoopCount, null);
    }

    public void animate(long[] pFrameDurations, int[] pFrames, int pLoopCount, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pFrameDurations, pFrames, pLoopCount);
        this.initAnimation(pAnimationListener);
    }

    public void animate(IAnimationData pAnimationData) {
        this.animate(pAnimationData, null);
    }

    public void animate(IAnimationData pAnimationData, IAnimationListener pAnimationListener) {
        this.mAnimationData.set(pAnimationData);
        this.initAnimation(pAnimationListener);
    }

    private void initAnimation(IAnimationListener pAnimationListener) {
        this.mAnimationStartedFired = false;
        this.mAnimationListener = pAnimationListener;
        this.mRemainingLoopCount = this.mAnimationData.getLoopCount();
        this.mAnimationProgress = 0L;
        this.mAnimationRunning = true;
    }

    public static interface IAnimationListener {
        public void onAnimationStarted(AnimatedSprite var1, int var2);

        public void onAnimationFrameChanged(AnimatedSprite var1, int var2, int var3);

        public void onAnimationLoopFinished(AnimatedSprite var1, int var2, int var3);

        public void onAnimationFinished(AnimatedSprite var1);
    }
}

