/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.sprite;

import java.util.Arrays;
import org.andengine.entity.sprite.IAnimationData;
import org.andengine.util.math.MathUtils;
import org.andengine.util.modifier.IModifier;

public class AnimationData
implements IAnimationData {
    private int mFrameCount;
    private int[] mFrames;
    private long[] mFrameDurations;
    private int mFirstFrameIndex;
    private int mLoopCount;
    private long[] mFrameEndsInNanoseconds;
    private long mAnimationDuration;

    @Deprecated
    public AnimationData() {
    }

    public AnimationData(long pFrameDurationEach, int pFrameCount) {
        this.set(pFrameDurationEach, pFrameCount);
    }

    public AnimationData(long pFrameDurationEach, int pFrameCount, boolean pLoop) {
        this.set(pFrameDurationEach, pFrameCount, pLoop);
    }

    public AnimationData(long pFrameDurationEach, int pFrameCount, int pLoopCount) {
        this.set(pFrameDurationEach, pFrameCount, pLoopCount);
    }

    public AnimationData(long[] pFrameDurations) {
        this.set(pFrameDurations);
    }

    public AnimationData(long[] pFrameDurations, boolean pLoop) {
        this.set(pFrameDurations, pLoop);
    }

    public AnimationData(long[] pFrameDurations, int pLoopCount) {
        this.set(pFrameDurations, pLoopCount);
    }

    public AnimationData(long[] pFrameDurations, int pFirstFrameIndex, int pLastFrameIndex, boolean pLoop) {
        this.set(pFrameDurations, pFirstFrameIndex, pLastFrameIndex, pLoop);
    }

    public AnimationData(long[] pFrameDurations, int[] pFrames, int pLoopCount) {
        this.set(pFrameDurations, pFrames, pLoopCount);
    }

    public AnimationData(long[] pFrameDurations, int pFirstFrameIndex, int pLastFrameIndex, int pLoopCount) {
        this.set(pFrameDurations, pFirstFrameIndex, pLastFrameIndex, pLoopCount);
    }

    public AnimationData(IAnimationData pAnimationData) {
        this.set(pAnimationData);
    }

    @Override
    public IAnimationData deepCopy() throws IModifier.DeepCopyNotSupportedException {
        return new AnimationData(this);
    }

    @Override
    public int[] getFrames() {
        return this.mFrames;
    }

    @Override
    public long[] getFrameDurations() {
        return this.mFrameDurations;
    }

    @Override
    public int getLoopCount() {
        return this.mLoopCount;
    }

    @Override
    public int getFrameCount() {
        return this.mFrameCount;
    }

    @Override
    public int getFirstFrameIndex() {
        return this.mFirstFrameIndex;
    }

    @Override
    public long getAnimationDuration() {
        return this.mAnimationDuration;
    }

    @Override
    public int calculateCurrentFrameIndex(long pAnimationProgress) {
        long[] frameEnds = this.mFrameEndsInNanoseconds;
        int frameCount = this.mFrameCount;
        for (int i = 0; i < frameCount; ++i) {
            if (frameEnds[i] <= pAnimationProgress) continue;
            return i;
        }
        return frameCount - 1;
    }

    @Override
    public void set(long pFrameDurationEach, int pFrameCount) {
        this.set(pFrameDurationEach, pFrameCount, true);
    }

    @Override
    public void set(long pFrameDurationEach, int pFrameCount, boolean pLoop) {
        this.set(pFrameDurationEach, pFrameCount, pLoop ? -1 : 0);
    }

    @Override
    public void set(long pFrameDurationEach, int pFrameCount, int pLoopCount) {
        this.set(AnimationData.fillFrameDurations(pFrameDurationEach, pFrameCount), pLoopCount);
    }

    @Override
    public void set(long[] pFrameDurations) {
        this.set(pFrameDurations, true);
    }

    @Override
    public void set(long[] pFrameDurations, boolean pLoop) {
        this.set(pFrameDurations, pLoop ? -1 : 0);
    }

    @Override
    public void set(long[] pFrameDurations, int pLoopCount) {
        this.set(pFrameDurations, 0, pFrameDurations.length - 1, pLoopCount);
    }

    @Override
    public void set(long[] pFrameDurations, int pFirstFrameIndex, int pLastFrameIndex) {
        this.set(pFrameDurations, pFirstFrameIndex, pLastFrameIndex, true);
    }

    @Override
    public void set(long[] pFrameDurations, int pFirstFrameIndex, int pLastFrameIndex, boolean pLoop) {
        this.set(pFrameDurations, pFirstFrameIndex, pLastFrameIndex, pLoop ? -1 : 0);
    }

    @Override
    public void set(long[] pFrameDurations, int pFirstFrameIndex, int pLastFrameIndex, int pLoopCount) {
        this.set(pFrameDurations, pLastFrameIndex - pFirstFrameIndex + 1, null, pFirstFrameIndex, pLoopCount);
        if (pFirstFrameIndex + 1 > pLastFrameIndex) {
            throw new IllegalArgumentException("An animation needs at least two tiles to animate between.");
        }
    }

    @Override
    public void set(long[] pFrameDurations, int[] pFrames) {
        this.set(pFrameDurations, pFrames, true);
    }

    @Override
    public void set(long[] pFrameDurations, int[] pFrames, boolean pLoop) {
        this.set(pFrameDurations, pFrames, pLoop ? -1 : 0);
    }

    @Override
    public void set(long[] pFrameDurations, int[] pFrames, int pLoopCount) {
        this.set(pFrameDurations, pFrames.length, pFrames, 0, pLoopCount);
    }

    @Override
    public void set(IAnimationData pAnimationData) {
        this.set(pAnimationData.getFrameDurations(), pAnimationData.getFrameCount(), pAnimationData.getFrames(), pAnimationData.getFirstFrameIndex(), pAnimationData.getLoopCount());
    }

    private void set(long[] pFrameDurations, int pFrameCount, int[] pFrames, int pFirstFrameIndex, int pLoopCount) {
        long lastFrameEnd;
        if (pFrameDurations.length != pFrameCount) {
            throw new IllegalArgumentException("pFrameDurations does not equal pFrameCount!");
        }
        this.mFrameDurations = pFrameDurations;
        this.mFrameCount = pFrameCount;
        this.mFrames = pFrames;
        this.mFirstFrameIndex = pFirstFrameIndex;
        this.mLoopCount = pLoopCount;
        if (this.mFrameEndsInNanoseconds == null || this.mFrameCount > this.mFrameEndsInNanoseconds.length) {
            this.mFrameEndsInNanoseconds = new long[this.mFrameCount];
        }
        long[] frameEndsInNanoseconds = this.mFrameEndsInNanoseconds;
        MathUtils.arraySumInto(this.mFrameDurations, frameEndsInNanoseconds, 1000000L);
        this.mAnimationDuration = lastFrameEnd = frameEndsInNanoseconds[this.mFrameCount - 1];
    }

    private static long[] fillFrameDurations(long pFrameDurationEach, int pFrameCount) {
        long[] frameDurations = new long[pFrameCount];
        Arrays.fill(frameDurations, pFrameDurationEach);
        return frameDurations;
    }
}

